/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.bali.xml.model.datatransfer.operation.PerformOperationAction;
import oracle.bali.xml.share.GroupingAction;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferDataInfo;

public abstract class Operation {
    public static final float STANDARD_OPERATIONS_RANK = 0.9f;
    public static final String FLATTENED_NAME = Operation.class.getName() + "-flattened name";

    public abstract int getSupportedActions();

    public boolean doesActionMutateModel() {
        return true;
    }

    public abstract List getApplicableDataAndPositions(AbstractModel var1, List var2, ExtendedTransferable var3);

    public abstract boolean apply(AbstractModel var1, DomPosition var2, TransferDataInfo var3, TransactionToken var4) throws IOException, XmlCommitException;

    public Action createAsAction(AbstractModel abstractModel, List list) {
        if (list.size() == 1) {
            DataAndPositions dataAndPositions = (DataAndPositions)list.get(0);
            TransferDataInfo transferDataInfo = dataAndPositions.getData();
            List list2 = dataAndPositions.getPositions();
            String string = this.getDisplayName(abstractModel, transferDataInfo);
            if (list2.size() == 1) {
                PerformOperationAction performOperationAction = new PerformOperationAction(this, abstractModel, transferDataInfo, (DomPosition)list2.get(0));
                performOperationAction.putValue("Name", string);
                return performOperationAction;
            }
            GroupingAction groupingAction = new GroupingAction();
            groupingAction.putValue("Name", string);
            for (DomPosition domPosition : list2) {
                PerformOperationAction performOperationAction = new PerformOperationAction(this, abstractModel, transferDataInfo, domPosition);
                performOperationAction.putValue("Name", this.getPositionDisplayName(abstractModel, domPosition));
                groupingAction.addChildAction(performOperationAction);
            }
            return groupingAction;
        }
        GroupingAction groupingAction = new GroupingAction();
        groupingAction.putValue("Name", this.getDisplayName(abstractModel, null));
        for (DataAndPositions dataAndPositions : list) {
            TransferDataInfo transferDataInfo = dataAndPositions.getData();
            PerformOperationAction performOperationAction = new PerformOperationAction(this, abstractModel, transferDataInfo, (DomPosition)dataAndPositions.getPositions().get(0));
            Object object = transferDataInfo.getMetadata(TransferDataInfo.METADATA_SHORT_DESCRIPTION);
            String string = object instanceof String ? (String)object : transferDataInfo.toString();
            performOperationAction.putValue("Name", string);
            groupingAction.addChildAction(performOperationAction);
        }
        return groupingAction;
    }

    public abstract String getDisplayName(AbstractModel var1, TransferDataInfo var2);

    protected final String getPositionDisplayName(AbstractModel abstractModel, DomPosition domPosition) {
        String string = domPosition.isBefore() ? "BeforePosition" : (domPosition.isAfter() ? "AfterPosition" : "InsidePosition");
        abstractModel.acquireReadLock();
        try {
            String string2 = abstractModel.getTranslatedString(string, abstractModel.getXmlMetadataResolver().getMediumDisplayName(domPosition.getTargetNode()));
            abstractModel.releaseReadLock();
            return string2;
        }
        catch (Throwable throwable) {
            abstractModel.releaseReadLock();
            throw throwable;
        }
    }

    public abstract float getSuitabilityRank();

    public static class RejectOperatingAndDontQueryLowerRankedOps
    extends RuntimeException {
    }
}

