/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.bali.xml.model.datatransfer.operation.Operation;
import oracle.bali.xml.model.datatransfer.operation.OperationManager;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.RefCounter;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.share.UnmodifiableIterator;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.logging.LogUtils;

public class OperationProcessor {
    public static final int SHOW_ALL_OPERATIONS = -1;
    private ExtendedTransferable _transferable;
    private int _actionMask;
    private boolean _editable;
    private AbstractModel _targetModel;
    private transient List _potentialOps;
    private transient Map _currentInfo;
    private final Map _locationsToInfoCache;
    private static final Logger _LOGGER = Logger.getLogger(OperationProcessor.class.getName());
    private static final Map _OPERATING_WAS_REJECTED = new 2();
    private static final Comparator _BY_RANK_COMPARATOR = new 1();

    public OperationProcessor(AbstractModel abstractModel) {
        this.$init$();
        this._targetModel = abstractModel;
    }

    public void setTransferable(ExtendedTransferable extendedTransferable) {
        if (extendedTransferable != this._transferable) {
            this._transferable = extendedTransferable;
            this._clearCaches();
        }
    }

    public void setTargetModel(AbstractModel abstractModel) {
        if (this._targetModel != abstractModel) {
            this._targetModel = abstractModel;
            this._clearCaches();
        }
    }

    public void setActionMask(int n) {
        if (n != this._actionMask) {
            this._actionMask = n;
            this._clearCaches();
        }
    }

    public void setEditable(boolean bl) {
        if (bl != this._editable) {
            this._editable = bl;
            this._clearCaches();
        }
    }

    public void update(List arrayList) {
        Map map = (Map)this._locationsToInfoCache.get(arrayList);
        if (map == null) {
            this._targetModel.acquireReadLock();
            try {
                map = this._computeInfo(arrayList);
                if (_LOGGER.isLoggable(Level.FINE)) {
                    _LOGGER.log(Level.FINE, "Computed info for {0}: {1}", new Object[]{arrayList, map});
                }
            }
            finally {
                this._targetModel.releaseReadLock();
            }
            arrayList = new ArrayList(arrayList);
            this._locationsToInfoCache.put(arrayList, map);
        }
        if (map != this._currentInfo) {
            this._currentInfo = map;
        }
    }

    public boolean hasSupportedOperation() {
        return this._currentInfo != null && !this._currentInfo.isEmpty();
    }

    public DomPosition getRepresentativeOperationPosition() {
        if (this._currentInfo != null) {
            RefCounter refCounter = new RefCounter();
            for (List list : this._currentInfo.values()) {
                for (DataAndPositions dataAndPositions : list) {
                    refCounter.addCount(dataAndPositions.getPositions().get(0));
                }
            }
            return (DomPosition)refCounter.getMaxValue();
        }
        return null;
    }

    public Iterator getSupportedOperations() {
        if (this._currentInfo != null) {
            return new UnmodifiableIterator(this._currentInfo.keySet().iterator());
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public List getListOfDataAndPositions(Operation operation) {
        if (this._currentInfo != null) {
            return (List)this._currentInfo.get(operation);
        }
        return null;
    }

    public boolean wasExplicitlyRejected() {
        return this._currentInfo != null && this._currentInfo == _OPERATING_WAS_REJECTED;
    }

    public boolean forceSimpleApplyWithoutTokenDispatch(TransactionToken transactionToken) throws XmlCommitException, IOException {
        if (transactionToken == null) {
            throw new IllegalArgumentException("token must be non-null");
        }
        return this._forceSimpleApplyImpl(transactionToken, null);
    }

    public boolean forceSimpleApply(TransactionToken transactionToken) throws XmlCommitException, IOException {
        return this.forceSimpleApply(transactionToken, null);
    }

    public boolean forceSimpleApply(TransactionToken transactionToken, String string) throws XmlCommitException, IOException {
        if (this._targetModel.getBaseModel().isInTransaction()) {
            throw new IllegalStateException("model is in transaction!");
        }
        if (!this.hasSupportedOperation()) {
            throw new IllegalStateException("! hasSupportedOperation()");
        }
        if (transactionToken == null && (transactionToken = this._targetModel.getContext().createTransactionToken()) != null) {
            transactionToken.setOwnerIfUnset(this);
        }
        boolean bl = false;
        try {
            bl = this._forceSimpleApplyImpl(transactionToken, string);
        }
        finally {
            TransactionToken.dispatch(transactionToken, this, bl);
        }
        return bl;
    }

    public boolean hasMoreThanOneOperationWithHighestRank() {
        Iterator iterator = this.getSupportedOperations();
        if (!iterator.hasNext()) {
            return false;
        }
        Operation operation = (Operation)iterator.next();
        if (iterator.hasNext()) {
            Operation operation2 = (Operation)iterator.next();
            if (operation.getSuitabilityRank() == operation2.getSuitabilityRank()) {
                return true;
            }
        }
        return false;
    }

    private boolean _forceSimpleApplyImpl(TransactionToken transactionToken, String string) throws XmlCommitException, IOException {
        boolean bl;
        Operation operation = (Operation)this.getSupportedOperations().next();
        List list = this.getListOfDataAndPositions(operation);
        DataAndPositions dataAndPositions = (DataAndPositions)list.get(0);
        DomPosition domPosition = (DomPosition)dataAndPositions.getPositions().iterator().next();
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "Calling op {0}, data {1}, pos {2} in forceSimplyApply", new Object[]{operation, dataAndPositions.getData(), domPosition});
        }
        if (string == null) {
            bl = this._apply(transactionToken, operation, dataAndPositions, domPosition);
        } else {
            Object[] objectArray = new Object[1];
            new 3(this, string, transactionToken, operation, dataAndPositions, domPosition, objectArray).runThrowingXCE(this._targetModel);
            if (objectArray[0] instanceof IOException) {
                throw (IOException)objectArray[0];
            }
            bl = (Boolean)objectArray[0];
        }
        if (bl) {
            _LOGGER.fine("last apply succeeded");
        } else {
            _LOGGER.fine("last apply returned false");
        }
        return bl;
    }

    private boolean _apply(TransactionToken transactionToken, Operation operation, DataAndPositions dataAndPositions, DomPosition domPosition) throws IOException, XmlCommitException {
        return operation.apply(this._targetModel, domPosition, dataAndPositions.getData(), transactionToken);
    }

    private Map _computeInfo(List list) {
        float f = Float.MIN_VALUE;
        TreeMap<Operation, List> treeMap = null;
        for (Operation operation : this._getPotentialOperations()) {
            boolean bl;
            if (!this._editable && operation.doesActionMutateModel()) continue;
            boolean bl2 = bl = this._actionMask == -1 || (this._actionMask & operation.getSupportedActions()) > 0;
            if (!bl) continue;
            try {
                List list2 = operation.getApplicableDataAndPositions(this._targetModel, list, this._transferable);
                if (list2.isEmpty()) continue;
                if (treeMap == null) {
                    treeMap = new TreeMap<Operation, List>(_BY_RANK_COMPARATOR);
                }
                treeMap.put(operation, list2);
            }
            catch (Operation.RejectOperatingAndDontQueryLowerRankedOps rejectOperatingAndDontQueryLowerRankedOps) {
                f = Math.max(f, operation.getSuitabilityRank());
            }
            catch (Exception exception) {
                LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Exception querying operation {0}", (Object)operation, (Throwable)exception);
            }
        }
        if (treeMap == null || treeMap.isEmpty()) {
            if (f > Float.MIN_VALUE) {
                return _OPERATING_WAS_REJECTED;
            }
            return Collections.EMPTY_MAP;
        }
        Operation operation = (Operation)treeMap.firstKey();
        if (operation.getSuitabilityRank() < f) {
            return _OPERATING_WAS_REJECTED;
        }
        return treeMap;
    }

    private List _getPotentialOperations() {
        if (this._potentialOps == null) {
            if (this._transferable == null) {
                return Collections.EMPTY_LIST;
            }
            OperationManager operationManager = this._targetModel.getContext().getOperationManager();
            this._potentialOps = operationManager.createApplicableOperations(this._transferable);
        }
        return this._potentialOps;
    }

    private void _clearCaches() {
        _LOGGER.finer("clearing caches");
        this._potentialOps = null;
        this._currentInfo = null;
        this._locationsToInfoCache.clear();
    }

    void $init$() {
        this._transferable = null;
        this._actionMask = -1;
        this._editable = true;
        this._targetModel = null;
        this._potentialOps = null;
        this._currentInfo = null;
        this._locationsToInfoCache = new HashMap();
    }

    static boolean mav$_apply(OperationProcessor operationProcessor, TransactionToken transactionToken, Operation operation, DataAndPositions dataAndPositions, DomPosition domPosition) {
        return operationProcessor._apply(transactionToken, operation, dataAndPositions, domPosition);
    }

    public final class 3
    extends FixedNameTransactionTask {
        private final /* synthetic */ TransactionToken v$token;
        private final /* synthetic */ Operation v$op;
        private final /* synthetic */ DataAndPositions v$dap;
        private final /* synthetic */ DomPosition v$pos;
        private final /* synthetic */ Object[] v$holder;
        final /* synthetic */ OperationProcessor this$0;

        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            try {
                boolean bl = OperationProcessor.mav$_apply(this.this$0, this.v$token, this.v$op, this.v$dap, this.v$pos);
                this.v$holder[0] = bl;
            }
            catch (IOException iOException) {
                this.v$holder[0] = iOException;
            }
        }

        public 3(OperationProcessor operationProcessor, String string, TransactionToken transactionToken, Operation operation, DataAndPositions dataAndPositions, DomPosition domPosition, Object[] objectArray) {
            this.v$holder = objectArray;
            this.v$pos = domPosition;
            this.v$dap = dataAndPositions;
            this.v$op = operation;
            this.v$token = transactionToken;
            this.this$0 = operationProcessor;
            super(string);
        }
    }

    public static final class 2
    extends AbstractMap {
        public Set entrySet() {
            return Collections.EMPTY_SET;
        }
    }

    public static final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            Operation operation = (Operation)object;
            Operation operation2 = (Operation)object2;
            float f = operation2.getSuitabilityRank() - operation.getSuitabilityRank();
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            if (operation.equals(operation2)) {
                return 0;
            }
            return operation.hashCode() - operation2.hashCode();
        }
    }
}

