/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.grammar;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.bali.xml.grammar.GrammarIdentifier;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceGrammarProvider;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.event.XmlModelAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class InstanceGrammarListener
extends XmlModelAdapter {
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String SCHEMA_LOCATION_ATTR = "schemaLocation";
    public static final String NO_NAMESPACE_ATTR = "noNamespaceSchemaLocation";

    public void listenerAttached(XmlModelEvent xmlModelEvent) {
        this._processEvent(xmlModelEvent);
    }

    public void listenerDetached(XmlModelEvent xmlModelEvent) {
        this._processEvent(xmlModelEvent);
    }

    public void modelChanged(XmlModelEvent xmlModelEvent) {
        this._processEvent(xmlModelEvent);
    }

    private void _processEvent(XmlModelEvent xmlModelEvent) {
        AbstractModel abstractModel = xmlModelEvent.getModel();
        XmlContext xmlContext = abstractModel.getContext();
        GrammarProvider grammarProvider = xmlContext.getGrammarProvider();
        if (xmlModelEvent.isDomTreeChanged() && grammarProvider instanceof XmlInstanceGrammarProvider) {
            XmlInstanceGrammarProvider xmlInstanceGrammarProvider = (XmlInstanceGrammarProvider)grammarProvider;
            GrammarIdentifier grammarIdentifier = null;
            HashSet hashSet = new HashSet();
            Document document = abstractModel.getDocument();
            if (document != null) {
                Element element;
                DocumentType documentType = document.getDoctype();
                if (documentType != null) {
                    String string = documentType.getPublicId();
                    String string2 = documentType.getSystemId();
                    if (string != null || string2 != null) {
                        grammarIdentifier = this._createIdentifier(xmlContext, null, string, string2);
                    }
                }
                if ((element = document.getDocumentElement()) != null) {
                    DocumentTraversal documentTraversal = (DocumentTraversal)((Object)document);
                    NodeIterator nodeIterator = documentTraversal.createNodeIterator(element, 1, null, false);
                    Node node = nodeIterator.nextNode();
                    while (node != null) {
                        Element element2 = (Element)node;
                        if (element2.hasAttributes()) {
                            Attr attr = element2.getAttributeNodeNS(XSI_NAMESPACE, SCHEMA_LOCATION_ATTR);
                            Attr attr2 = element2.getAttributeNodeNS(XSI_NAMESPACE, NO_NAMESPACE_ATTR);
                            if (attr != null) {
                                this._processSchemaLocationAttr(xmlContext, attr, hashSet);
                            }
                            if (attr2 != null) {
                                this._processNoNamespaceAttr(xmlContext, attr2, hashSet);
                            }
                        }
                        node = nodeIterator.nextNode();
                    }
                    nodeIterator.detach();
                }
            }
            xmlInstanceGrammarProvider.setSchemaIdentifiers(hashSet);
            xmlInstanceGrammarProvider.setDtdIdentifier(grammarIdentifier);
        }
    }

    private void _processSchemaLocationAttr(XmlContext xmlContext, Attr attr, HashSet hashSet) {
        String string = attr.getValue();
        if (string != null) {
            List list = this._getTokens(string);
            int n = list.size();
            int n2 = 0;
            int n3 = 1;
            while (n3 < n) {
                String string2 = (String)list.get(n2);
                String string3 = (String)list.get(n3);
                GrammarIdentifier grammarIdentifier = this._createIdentifier(xmlContext, string2, null, string3);
                hashSet.add(grammarIdentifier);
                n2 += 2;
                n3 += 2;
            }
        }
    }

    private void _processNoNamespaceAttr(XmlContext xmlContext, Attr attr, HashSet hashSet) {
        String string = attr.getValue();
        if (string != null && string.length() > 0) {
            GrammarIdentifier grammarIdentifier = this._createIdentifier(xmlContext, null, null, string);
            hashSet.add(grammarIdentifier);
        }
    }

    private List _getTokens(String string) {
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        if (string != null) {
            arrayList = new ArrayList<String>(6);
            char[] cArray = string.toCharArray();
            int n = 0;
            int n2 = -1;
            while (n < cArray.length) {
                char c = cArray[n];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (n2 == -1) break;
                        String string2 = new String(cArray, n2, n - n2);
                        arrayList.add(string2);
                        n2 = -1;
                        break;
                    }
                    default: {
                        if (n2 != -1) break;
                        n2 = n;
                    }
                }
                ++n;
            }
            if (n2 != -1) {
                String string3 = new String(cArray, n2, n - n2);
                arrayList.add(string3);
                n2 = -1;
            }
        }
        return arrayList;
    }

    private GrammarIdentifier _createIdentifier(XmlContext xmlContext, String string, String string2, String string3) {
        String string4 = this._resolveLocation(xmlContext, string3);
        return GrammarIdentifier.getGrammarIdentifier((String)string, (String)string2, (String)string4);
    }

    private String _resolveLocation(XmlContext xmlContext, String string) {
        URL uRL;
        if (string != null && (uRL = xmlContext.getURLForRelativePath(string)) != null) {
            return uRL.toExternalForm();
        }
        return string;
    }
}

