/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.grammar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.Particle;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ProspectiveValidator {
    private final XmlModel _model;
    private final GrammarResolver _grammarResolver;

    public ProspectiveValidator(XmlModel xmlModel) {
        this._model = xmlModel;
        this._grammarResolver = this._model.getContext().getGrammarResolver();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DomPosition findValidInsertionPosition(XmlKey xmlKey, Node node, DomPosition domPosition, XmlKey xmlKey2) {
        XmlMetadataResolver xmlMetadataResolver;
        ElementDef elementDef;
        String string = null;
        String string2 = null;
        QualifiedName qualifiedName = null;
        if (xmlKey != null) {
            if (xmlKey.getNodeType() != 1) return domPosition;
            qualifiedName = xmlKey.getElementQName();
            string = qualifiedName.getNamespace();
            string2 = qualifiedName.getName();
            if (qualifiedName.isVariation()) {
                qualifiedName = QualifiedName.getQualifiedName((String)string, (String)string2);
            }
        } else {
            if (node == null) return domPosition;
            if (node.getNodeType() != 1) return domPosition;
            string = node.getNamespaceURI();
            string2 = DomUtils.getLocalName((Node)node);
            qualifiedName = QualifiedName.getQualifiedName((String)string, (String)string2);
        }
        if (domPosition.hasAttributeQName()) {
            return null;
        }
        if (domPosition.hasTextOffset()) {
            return domPosition;
        }
        LinkedHashSet<DomPosition> linkedHashSet = null;
        Node node2 = domPosition.getContainerNode();
        if (xmlKey2 == null) {
            xmlKey2 = this._model.getNodeXmlKey(node2);
        }
        if (DomUtils.isElement((Node)node2) && (elementDef = (ElementDef)(xmlMetadataResolver = this._model.getXmlMetadataResolver()).getGrammarComponent(xmlKey2)) != null) {
            Type type = elementDef.getType();
            if (type instanceof ComplexType) {
                ComplexType complexType = (ComplexType)type;
                ContentGroup contentGroup = complexType.getContentGroup();
                if (contentGroup.getVariety() == 9) {
                    linkedHashSet = new LinkedHashSet<DomPosition>();
                    Element element = null;
                    Element element2 = DomUtils.getFirstElementChild((Node)node2);
                    QualifiedName qualifiedName2 = null;
                    if (element2 != null) {
                        qualifiedName2 = QualifiedName.getQualifiedName((String)element2.getNamespaceURI(), (String)DomUtils.getLocalName((Node)element2));
                    }
                    List list = this._flattenSequenceContents(contentGroup.getComponents());
                    for (FlattenedParticle flattenedParticle : list) {
                        int n = flattenedParticle.getMaxOccurs();
                        ArrayList<Element> arrayList = new ArrayList<Element>(5);
                        while (element2 != null) {
                            if (n != -1 && arrayList.size() >= n || !flattenedParticle.accepts(qualifiedName2)) break;
                            arrayList.add(element2);
                            element = element2;
                            element2 = DomUtils.getNextElementSibling((Node)element2);
                            if (element2 != null) {
                                qualifiedName2 = QualifiedName.getQualifiedName((String)element2.getNamespaceURI(), (String)DomUtils.getLocalName((Node)element2));
                                continue;
                            }
                            qualifiedName2 = null;
                        }
                        if (n != -1 && arrayList.size() >= n || !flattenedParticle.accepts(qualifiedName)) continue;
                        if (arrayList.isEmpty()) {
                            if (element2 == null) {
                                if (element == null) {
                                    linkedHashSet.add(DomPositionFactory.inside((Node)node2));
                                    continue;
                                }
                                linkedHashSet.add(DomPositionFactory.after((Node)element));
                                continue;
                            }
                            linkedHashSet.add(DomPositionFactory.before((Node)element2));
                            continue;
                        }
                        for (Node node3 : arrayList) {
                            linkedHashSet.add(DomPositionFactory.before((Node)node3));
                            linkedHashSet.add(DomPositionFactory.after((Node)node3));
                        }
                    }
                }
            } else {
                linkedHashSet = Collections.EMPTY_SET;
            }
        }
        if (linkedHashSet != null) {
            if (linkedHashSet.size() <= 0) return null;
            DomPosition domPosition2 = this._getPositionFromComparator(node2, node);
            if (DomUtils.containsPositionOrEquivalent((TreeTraversal)this._model.getTreeTraversal(), (Set)linkedHashSet, (DomPosition)domPosition2)) {
                return domPosition2;
            }
            if (DomUtils.containsPositionOrEquivalent((TreeTraversal)this._model.getTreeTraversal(), (Set)linkedHashSet, (DomPosition)domPosition)) {
                return domPosition;
            }
            Iterator iterator = linkedHashSet.iterator();
            DomPosition domPosition3 = null;
            while (iterator.hasNext()) {
                domPosition3 = (DomPosition)iterator.next();
            }
            return domPosition3;
        }
        DomPosition domPosition4 = this._getPositionFromComparator(node2, node);
        if (domPosition4 == null) return domPosition;
        return domPosition4;
    }

    private List _flattenSequenceContents(Collection collection) {
        ArrayList<FlattenedParticle> arrayList = new ArrayList<FlattenedParticle>();
        if (collection != null) {
            for (Object e : collection) {
                if (!(e instanceof Particle)) continue;
                Particle particle = (Particle)e;
                FlattenedParticle flattenedParticle = this._createFlattenedParticle(particle);
                if (flattenedParticle instanceof FlattenedContentGroup) {
                    FlattenedContentGroup flattenedContentGroup = (FlattenedContentGroup)flattenedParticle;
                    if (flattenedContentGroup.getVariety() == 9) {
                        arrayList.addAll(flattenedContentGroup.getFlattenedParticles());
                        continue;
                    }
                    arrayList.add(flattenedContentGroup);
                    continue;
                }
                arrayList.add(flattenedParticle);
            }
        }
        return arrayList;
    }

    private DomPosition _getPositionFromComparator(Node node, Node node2) {
        if (node == null || node2 == null) {
            return null;
        }
        if (!node.hasChildNodes()) {
            return DomPositionFactory.inside((Node)node);
        }
        Comparator comparator = this._model.getXmlMetadataResolver().getInsertionComparator(node);
        if (comparator == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        Node[] nodeArray = new Node[n];
        int n2 = 0;
        while (n2 < n) {
            nodeArray[n2] = nodeList.item(n2);
            ++n2;
        }
        Arrays.sort(nodeArray, comparator);
        int n3 = Arrays.binarySearch(nodeArray, node2, comparator);
        if (n3 >= 0) {
            return DomPositionFactory.after((Node)nodeArray[n3]);
        }
        int n4 = -(n3 + 1);
        if (n4 >= n) {
            return DomPositionFactory.inside((Node)node);
        }
        return DomPositionFactory.before((Node)nodeArray[n4]);
    }

    private FlattenedParticle _createFlattenedParticle(Particle particle) {
        FlattenedParticle flattenedParticle = null;
        if (particle instanceof ElementDef) {
            ElementDef elementDef = (ElementDef)particle;
            flattenedParticle = new FlattenedElementDef(elementDef);
        } else if (particle instanceof Wildcard) {
            Wildcard wildcard = (Wildcard)particle;
            flattenedParticle = new FlattenedWildcard(wildcard);
        } else if (particle instanceof ContentGroup) {
            ContentGroup contentGroup = (ContentGroup)particle;
            flattenedParticle = new FlattenedContentGroup(contentGroup);
        }
        return flattenedParticle;
    }

    static GrammarResolver ra$_grammarResolver(ProspectiveValidator prospectiveValidator) {
        return prospectiveValidator._grammarResolver;
    }

    static FlattenedParticle mav$_createFlattenedParticle(ProspectiveValidator prospectiveValidator, Particle particle) {
        return prospectiveValidator._createFlattenedParticle(particle);
    }

    public abstract class FlattenedParticle {
        public abstract boolean accepts(QualifiedName var1);

        public abstract int getMaxOccurs();
    }

    private class FlattenedElementDef
    extends FlattenedParticle {
        private final ElementDef _elementDef;
        private final SubstitutionGroup _substGroup;

        public FlattenedElementDef(ElementDef elementDef) {
            this._elementDef = elementDef;
            this._substGroup = elementDef.getSubstitutionGroup();
        }

        public boolean accepts(QualifiedName qualifiedName) {
            return this._elementDef.getQualifiedName().equals((Object)qualifiedName) ? !this._elementDef.isAbstract() : this._substGroup != null && this._substGroup.getElementDefByName(qualifiedName) != null;
        }

        public int getMaxOccurs() {
            return this._elementDef.getMaxOccurs();
        }
    }

    private class FlattenedWildcard
    extends FlattenedParticle {
        private final Wildcard _wildcard;

        public FlattenedWildcard(Wildcard wildcard) {
            this._wildcard = wildcard;
        }

        public boolean accepts(QualifiedName qualifiedName) {
            String string = qualifiedName.getNamespace();
            if (TypeUtils.wildcardAllowsNamespace((Wildcard)this._wildcard, (String)string)) {
                if (this._wildcard.getProcessingRule() == 0) {
                    Grammar grammar = ProspectiveValidator.ra$_grammarResolver(ProspectiveValidator.this).getGrammarForNamespace(string);
                    if (grammar != null && grammar.getElementDefByName(qualifiedName.getName()) != null) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        public int getMaxOccurs() {
            return this._wildcard.getMaxOccurs();
        }
    }

    private class FlattenedContentGroup
    extends FlattenedParticle {
        private List _flattenedParticles;
        private final ContentGroup _contentGroup;

        public FlattenedContentGroup(ContentGroup contentGroup) {
            this.$init$();
            this._contentGroup = contentGroup;
        }

        public int getVariety() {
            return this._contentGroup.getVariety();
        }

        public boolean accepts(QualifiedName qualifiedName) {
            List list = this.getFlattenedParticles();
            Iterator iterator = list.iterator();
            FlattenedParticle flattenedParticle = null;
            while (iterator.hasNext()) {
                flattenedParticle = (FlattenedParticle)iterator.next();
                if (!flattenedParticle.accepts(qualifiedName)) continue;
                return true;
            }
            return false;
        }

        public int getMaxOccurs() {
            FlattenedParticle flattenedParticle;
            int n;
            List list = this.getFlattenedParticles();
            if (list.size() == 1 && this._contentGroup.getMaxOccurs() != -1 && (n = (flattenedParticle = (FlattenedParticle)list.get(0)).getMaxOccurs()) != -1) {
                return n * this._contentGroup.getMaxOccurs();
            }
            return -1;
        }

        public List getFlattenedParticles() {
            if (this._flattenedParticles == null) {
                this._flattenedParticles = new ArrayList();
                Collection collection = this._contentGroup.getComponents();
                if (collection != null) {
                    for (Object e : collection) {
                        Particle particle;
                        FlattenedParticle flattenedParticle;
                        if (!(e instanceof Particle) || (flattenedParticle = ProspectiveValidator.mav$_createFlattenedParticle(ProspectiveValidator.this, particle = (Particle)e)) == null) continue;
                        this._flattenedParticles.add(flattenedParticle);
                    }
                }
            }
            return this._flattenedParticles;
        }

        void $init$() {
            this._flattenedParticles = null;
        }
    }
}

