/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.logging.Level;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public class ValidationExceptionMessage
extends XmlModelMessage {
    private final ValidationException _ex;
    private final Level _level;

    public ValidationExceptionMessage(XmlModel xmlModel, ValidationException validationException, Level level) {
        super(xmlModel);
        this._ex = validationException;
        this._level = level;
    }

    public MessageCategory getCategory() {
        return MessageCategory.GRAMMAR_VALIDITY;
    }

    public Level getLevel() {
        return this._level;
    }

    public String getShortDescription() {
        return this._ex.getLocalizedMessage();
    }

    public String getLongDescription() {
        String string = this.getShortDescription();
        Exception exception = this._ex.getException();
        if (exception != null) {
            string = string + "\n\n" + exception.getLocalizedMessage();
        }
        return string;
    }

    public Node getRelatedNode() {
        return this._ex.getInvalidNode();
    }

    public Object getCause() {
        return this._ex;
    }
}

