/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.SimpleMessage;
import oracle.bali.xml.model.message.ValidationExceptionMessage;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.validator.ValidationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationHandler
implements ErrorHandler {
    private Level _highestLevel;
    private final List _messages;
    private final MessageCategory _category;
    private final XmlModel _model;
    private final List _immutableMessages;

    public ValidationHandler(XmlModel xmlModel, MessageCategory messageCategory) {
        this.$init$();
        this._model = xmlModel;
        this._category = messageCategory;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        Level level = XmlModelMessage.WARNING;
        if (this._isWarningActuallyInfo(sAXParseException)) {
            level = XmlModelMessage.INFO;
        }
        this._create(sAXParseException, level);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this._create(sAXParseException, XmlModelMessage.ERROR);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this._create(sAXParseException, XmlModelMessage.ERROR);
    }

    public Level getHighestLevel() {
        return this._highestLevel;
    }

    public List getMessages() {
        return this._immutableMessages;
    }

    public boolean isEmpty() {
        return this._messages.isEmpty();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : this._messages) {
            if (e == null) continue;
            stringBuffer.append(e);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private boolean _isWarningActuallyInfo(SAXParseException sAXParseException) {
        ValidationException validationException;
        int n;
        return sAXParseException instanceof ValidationException && (n = (validationException = (ValidationException)sAXParseException).getType()) == 11;
    }

    private void _create(SAXParseException sAXParseException, Level level) {
        XmlModelMessage xmlModelMessage = sAXParseException instanceof ValidationException ? new ValidationExceptionMessage(this._model, (ValidationException)sAXParseException, level) : new SimpleMessage(this._model, this._category, level, sAXParseException.getLocalizedMessage(), sAXParseException);
        this._messages.add(xmlModelMessage);
        if (level.intValue() > this._highestLevel.intValue()) {
            this._highestLevel = level;
        }
    }

    void $init$() {
        this._highestLevel = Level.FINEST;
        this._messages = new ArrayList();
        this._immutableMessages = Collections.unmodifiableList(this._messages);
    }
}

