/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.logging.Level;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.share.FastMessageFormat;
import org.w3c.dom.Node;

public abstract class XmlModelMessage {
    public static final Level ERROR = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    public static final Level INFO = Level.INFO;
    private final XmlModel _model;

    public abstract Level getLevel();

    public abstract String getShortDescription();

    public abstract MessageCategory getCategory();

    public int getTextStartOffset() {
        return this._textOffset(this.getRelatedNode(), true);
    }

    public int getTextEndOffset() {
        return this._textOffset(this.getRelatedNode(), false);
    }

    public Node getRelatedNode() {
        return null;
    }

    public String getLongDescription() {
        return this.getShortDescription();
    }

    public Object getCause() {
        return null;
    }

    public final boolean isAtLeastLevel(Level level) {
        return this.getLevel().intValue() >= level.intValue();
    }

    public final boolean isExactLevel(Level level) {
        return this.getLevel().intValue() == level.intValue();
    }

    public final boolean isError() {
        return this.isAtLeastLevel(ERROR);
    }

    public final boolean isWarning() {
        return this.isExactLevel(WARNING);
    }

    public final boolean isAtLeastWarning() {
        return this.isAtLeastLevel(WARNING);
    }

    public final boolean isAtLeastInfo() {
        return this.isAtLeastLevel(INFO);
    }

    public String toString() {
        String string = "{0}: {1} [ node = {2} ]";
        String string2 = "{0}: {1}";
        Node node = this.getRelatedNode();
        if (node == null) {
            return FastMessageFormat.formatMessage(string2, this.getLevel().getLocalizedName(), this.getLongDescription());
        }
        return FastMessageFormat.formatMessage(string, this.getLevel().getLocalizedName(), this.getLongDescription(), node.getNodeName());
    }

    public final XmlModel getModel() {
        return this._model;
    }

    protected XmlModelMessage(XmlModel xmlModel) {
        this._model = xmlModel;
    }

    private int _textOffset(Node node, boolean bl) {
        if (node != null) {
            this._model.acquireReadLock();
            try {
                DomPosition domPosition = null;
                switch (node.getNodeType()) {
                    case 9: {
                        break;
                    }
                    case 2: {
                        if (bl) {
                            domPosition = DomPositionFactory.createInsideOrBeforePosition((Node)node);
                            break;
                        }
                        domPosition = DomPositionFactory.createInsideOrAfterPosition((Node)node);
                        break;
                    }
                    default: {
                        int n = bl ? 1 : 2;
                        domPosition = DomPositionFactory.createDomPosition((Node)node, (int)n);
                    }
                }
                if (domPosition != null) {
                    int n = this._model.getTextOffset(domPosition);
                    this._model.releaseReadLock();
                    return n;
                }
            }
            finally {
                this._model.releaseReadLock();
            }
        }
        return -1;
    }
}

