/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.share.CollectionCollectionIterator;
import org.w3c.dom.Node;

public class XmlModelMessageLog {
    private final Map _messages;

    public XmlModelMessageLog(List list, List list2) {
        HashMap hashMap = new HashMap(7);
        this._addMessages(hashMap, MessageCategory.PARSING, list);
        this._addMessages(hashMap, MessageCategory.GRAMMAR_VALIDITY, list2);
        this._messages = Collections.unmodifiableMap(hashMap);
    }

    public XmlModelMessageLog(Map map) {
        this._messages = Collections.unmodifiableMap(map);
    }

    public XmlModelMessageLog() {
        this._messages = Collections.EMPTY_MAP;
    }

    public List getMessages(MessageCategory messageCategory) {
        Object v = this._messages.get(messageCategory);
        if (v instanceof List) {
            return (List)v;
        }
        return Collections.EMPTY_LIST;
    }

    public List getNodeMessageList(Node node) {
        ArrayList<XmlModelMessage> arrayList = Collections.EMPTY_LIST;
        if (node == null) {
            return arrayList;
        }
        Map map = this.getMessagesMap();
        Collection collection = map.values();
        for (List list : collection) {
            for (XmlModelMessage xmlModelMessage : list) {
                if (xmlModelMessage.getRelatedNode() != node) continue;
                if (arrayList == Collections.EMPTY_LIST) {
                    arrayList = new ArrayList<XmlModelMessage>();
                }
                arrayList.add(xmlModelMessage);
            }
        }
        return arrayList;
    }

    public Map getMessagesMap() {
        return this._messages;
    }

    public Iterator iterator() {
        return new CollectionCollectionIterator(this._messages.values());
    }

    public XmlModelMessageLog getUpdatedLog(MessageCategory messageCategory, List list) {
        HashMap<MessageCategory, List> hashMap = new HashMap<MessageCategory, List>(this._messages);
        if (list == null || list.isEmpty()) {
            hashMap.remove(messageCategory);
        } else {
            hashMap.put(messageCategory, list);
        }
        return new XmlModelMessageLog(hashMap);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this._messages.values().iterator();
        while (iterator.hasNext()) {
            this._toString(stringBuffer, (List)iterator.next());
        }
        return stringBuffer.toString();
    }

    private void _toString(StringBuffer stringBuffer, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append("\n");
        }
    }

    private void _addMessages(Map map, MessageCategory messageCategory, List list) {
        if (list != null && !list.isEmpty()) {
            map.put(messageCategory, list);
        }
    }
}

