/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.RefInfo;
import oracle.bali.xml.model.metadata.refinfo.RefInfoResolver;
import org.w3c.dom.Node;

public class IntrospectionRefInfoResolver
extends RefInfoResolver {
    private static final Object _DUMMY = new Object();
    private HashMap _classNameToClass;
    private HashMap _methods;
    private HashMap _properties;

    public void goToDeclaration(XmlContext xmlContext, Node node, RefInfo refInfo) {
    }

    public void dispose(XmlContext xmlContext) {
        this._classNameToClass.clear();
        this._methods.clear();
        this._properties.clear();
    }

    public boolean classExists(XmlContext xmlContext, String string) {
        return this._getClass(string) != null;
    }

    public boolean classMatchesType(XmlContext xmlContext, String string, String string2) {
        Class clazz = this._getClass(string);
        if (clazz == null) {
            return false;
        }
        if (this._isEmpty(string2)) {
            return true;
        }
        Class clazz2 = this._getClass(string2);
        if (clazz2 == null) {
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public boolean methodExists(XmlContext xmlContext, String string, String string2, String string3, String[] stringArray) {
        Class clazz = this._getClass(string);
        if (clazz == null) {
            return false;
        }
        return this._getMethod(clazz, string2, string3, stringArray) != null;
    }

    public boolean propertyExists(XmlContext xmlContext, String string, String string2, String string3, int n) {
        Class clazz = this._getClass(string);
        if (clazz == null) {
            return false;
        }
        return this._propertyExists(clazz, string2, string3, n);
    }

    public boolean uriExists(XmlContext xmlContext, String string, String string2) {
        try {
            File file = new File(string);
            if (file.exists()) {
                File file2 = new File(file, string2);
                boolean bl = file2.exists();
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean _isEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    private Class _getClass(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        Object object = this._classNameToClass.get(string);
        if (object == null) {
            try {
                object = ClassLoaderUtils.loadClass((String)string);
            }
            catch (Exception exception) {
                object = _DUMMY;
            }
            this._classNameToClass.put(string, object);
        }
        return object == _DUMMY ? null : (Class)object;
    }

    private Method _getMethod(Class clazz, String string, String string2, String[] stringArray) {
        MethodKey methodKey = new MethodKey(clazz.getName(), string, string2, stringArray);
        Object object = this._methods.get(methodKey);
        if (object == null) {
            try {
                Class[] classArray = new Class[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    Class clazz2 = this._getClass(stringArray[n]);
                    if (clazz2 == null) {
                        throw new ClassNotFoundException(stringArray[n]);
                    }
                    classArray[n] = clazz2;
                    ++n;
                }
                Class clazz3 = this._getClass(string2);
                Method method = clazz.getMethod(string, classArray);
                if (method.getReturnType() == clazz3) {
                    object = method;
                }
            }
            catch (Exception exception) {
                object = _DUMMY;
            }
            this._methods.put(methodKey, object);
        }
        return object == _DUMMY ? null : (Method)object;
    }

    private boolean _propertyExists(Class clazz, String string, String string2, int n) {
        PropertyKey propertyKey = new PropertyKey(clazz.getName(), string, string2);
        Boolean bl = (Boolean)this._properties.get(propertyKey);
        if (bl != null) {
            return bl;
        }
        bl = Boolean.FALSE;
        boolean bl2 = true;
        if ((n & 1) != 0) {
            String string3 = IntrospectionRefInfoResolver._isBoolean(string2) ? "is" : "get";
            String string4 = IntrospectionRefInfoResolver._getMethodName(string3, string);
            Method method = this._getMethod(clazz, string4, string2, null);
            bl2 = method != null;
        }
        boolean bl3 = true;
        if ((n & 2) != 0) {
            String string5 = IntrospectionRefInfoResolver._getMethodName("set", string);
            Method method = this._getMethod(clazz, string5, null, new String[]{string2});
            bl3 = method != null;
        }
        bl = bl2 && bl3;
        this._properties.put(propertyKey, bl);
        return bl;
    }

    private static boolean _isBoolean(String string) {
        return "boolean".equals(string) || "Boolean".equals(string) || "java.lang.Boolean".equals(string);
    }

    private static String _getMethodName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length());
        stringBuffer.append(string);
        stringBuffer.append(Character.toUpperCase(string2.charAt(0)));
        stringBuffer.append(string2.substring(1));
        return stringBuffer.toString();
    }

    private static boolean _equals(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null) {
            return string.equals(string2);
        }
        return false;
    }

    private static boolean _equals(String[] stringArray, String[] stringArray2) {
        return Arrays.equals(stringArray, stringArray2);
    }

    private static int _hashCode(String string, String string2, String string3, String[] stringArray) {
        int n = IntrospectionRefInfoResolver._size(string) + IntrospectionRefInfoResolver._size(string2) + IntrospectionRefInfoResolver._size(string3) + IntrospectionRefInfoResolver._size(stringArray);
        StringBuffer stringBuffer = new StringBuffer(n + 3);
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(':');
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        stringBuffer.append(':');
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
        }
        return stringBuffer.hashCode();
    }

    private static int _size(String string) {
        return string == null ? 0 : string.length();
    }

    private static int _size(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n += stringArray[n2].length();
            ++n2;
        }
        return n;
    }

    void $init$() {
        this._classNameToClass = new HashMap(10);
        this._methods = new HashMap(10);
        this._properties = new HashMap(10);
    }

    public IntrospectionRefInfoResolver() {
        this.$init$();
    }

    static boolean maS$_equals(String string, String string2) {
        return IntrospectionRefInfoResolver._equals(string, string2);
    }

    static boolean maS$_equals(String[] stringArray, String[] stringArray2) {
        return IntrospectionRefInfoResolver._equals(stringArray, stringArray2);
    }

    static int maS$_hashCode(String string, String string2, String string3, String[] stringArray) {
        return IntrospectionRefInfoResolver._hashCode(string, string2, string3, stringArray);
    }

    private static class MethodKey {
        private String _className;
        private String _name;
        private String _returnType;
        private String[] _parameters;
        private int _hashCode;

        public MethodKey(String string, String string2, String string3, String[] stringArray) {
            this._className = string;
            this._name = string2;
            this._returnType = string3;
            this._parameters = stringArray;
            this._hashCode = IntrospectionRefInfoResolver.maS$_hashCode(string, string2, string3, stringArray);
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MethodKey)) {
                return false;
            }
            MethodKey methodKey = (MethodKey)object;
            return IntrospectionRefInfoResolver.maS$_equals(methodKey._className, this._className) && IntrospectionRefInfoResolver.maS$_equals(methodKey._name, this._name) && IntrospectionRefInfoResolver.maS$_equals(methodKey._returnType, this._returnType) && IntrospectionRefInfoResolver.maS$_equals(methodKey._parameters, this._parameters);
        }
    }

    private static class PropertyKey {
        private String _className;
        private String _name;
        private String _type;
        private int _hashCode;

        public PropertyKey(String string, String string2, String string3) {
            this._className = string;
            this._name = string2;
            this._type = string3;
            this._hashCode = IntrospectionRefInfoResolver.maS$_hashCode(string, string2, string3, null);
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PropertyKey)) {
                return false;
            }
            PropertyKey propertyKey = (PropertyKey)object;
            return IntrospectionRefInfoResolver.maS$_equals(propertyKey._className, this._className) && IntrospectionRefInfoResolver.maS$_equals(propertyKey._name, this._name) && IntrospectionRefInfoResolver.maS$_equals(propertyKey._type, this._type);
        }
    }
}

