/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.RefInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class JavaInfo
extends RefInfo {
    public static final int VALIDATION_ERROR_CLASS_EMPTY = 130;
    public static final int VALIDATION_WARNING_CLASS_EMPTY = 131;
    public static final int VALIDATION_ERROR_CLASS_NOT_FOUND = 132;
    public static final int VALIDATION_WARNING_CLASS_NOT_FOUND = 133;
    public static final int VALIDATION_ERROR_CLASS_NO_MATCH = 134;
    public static final int VALIDATION_WARNING_CLASS_NO_MATCH = 135;
    public static final int VALIDATION_ERROR_METHOD_EMPTY = 136;
    public static final int VALIDATION_WARNING_METHOD_EMPTY = 137;
    public static final int VALIDATION_ERROR_METHOD_NOT_FOUND = 138;
    public static final int VALIDATION_WARNING_METHOD_NOT_FOUND = 139;
    public static final int VALIDATION_ERROR_PROPERTY_EMPTY = 140;
    public static final int VALIDATION_WARNING_PROPERTY_EMPTY = 141;
    public static final int VALIDATION_ERROR_PROPERTY_NOT_FOUND = 142;
    public static final int VALIDATION_WARNING_PROPERTY_NOT_FOUND = 143;
    private static final String _ARRAY_IDENTIFIER = "[]";

    public void goToDeclaration(XmlContext xmlContext, Node node) {
        xmlContext.getRefInfoResolver().goToDeclaration(xmlContext, node, this);
    }

    protected boolean isArray(String string) {
        return string != null && string.endsWith(_ARRAY_IDENTIFIER);
    }

    protected boolean isBuiltInType(String string) {
        if (this.isArray(string)) {
            string = this._getArrayType(string);
        }
        return "int".equals(string) || "float".equals(string) || "double".equals(string) || "byte".equals(string) || "boolean".equals(string) || "short".equals(string) || "long".equals(string) || "char".equals(string);
    }

    protected void validateClassName(XmlContext xmlContext, Node node, String string, int n) throws ValidationException {
        boolean bl;
        if (string == null || "".equals(string)) {
            String string2 = xmlContext.getTranslatedString("CLASS_EMPTY");
            int n2 = n == 0 ? 130 : 131;
            ValidationException validationException = new ValidationException(n2, string2, node);
            validationException.setRelatedObject((Object)this);
            throw validationException;
        }
        if (!this.isDatabound(xmlContext, node) && !(bl = xmlContext.getRefInfoResolver().classExists(xmlContext, string))) {
            String string3 = xmlContext.getTranslatedString("CLASS_NOT_FOUND");
            int n3 = n == 0 ? 132 : 133;
            ValidationException validationException = new ValidationException(n3, FastMessageFormat.formatMessage(string3, string), node);
            validationException.setRelatedObject((Object)this);
            throw validationException;
        }
    }

    protected void validateClassName(XmlContext xmlContext, Node node, String string, String string2, int n) throws ValidationException {
        this.validateClassName(xmlContext, node, string, n);
        if (!this.isDatabound(xmlContext, node) && !xmlContext.getRefInfoResolver().classMatchesType(xmlContext, string, string2)) {
            String string3 = xmlContext.getTranslatedString("CLASS_NO_MATCH");
            int n2 = n == 0 ? 134 : 135;
            ValidationException validationException = new ValidationException(n2, FastMessageFormat.formatMessage(string3, string, string2), node);
            validationException.setRelatedObject((Object)this);
            throw validationException;
        }
    }

    private String _getArrayType(String string) {
        if (string != null && string.endsWith(_ARRAY_IDENTIFIER)) {
            return string.substring(0, string.length() - _ARRAY_IDENTIFIER.length());
        }
        return string;
    }
}

