/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.java.SingleClassJavaInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultipleBaseTypeJavaInfo
extends SingleClassJavaInfo {
    private String[] _classTypes;
    private int _errorLevel;

    public MultipleBaseTypeJavaInfo() {
        this(null, 2);
    }

    public MultipleBaseTypeJavaInfo(String[] stringArray) {
        this(stringArray, 2);
    }

    public MultipleBaseTypeJavaInfo(String[] stringArray, int n) {
        this._classTypes = stringArray;
        this._errorLevel = n;
    }

    public String[] getBaseTypes() {
        return this._classTypes;
    }

    public int getErrorLevel() {
        return this._errorLevel;
    }

    public String getFullyQualifiedClassName(Node node) {
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            return DomUtils.getTextNodeValue((Node)node);
        }
        throw new IllegalArgumentException("MultipleBaseTypeJavaInfo is being used with something other than element or attribute");
    }

    public void setFullyQualifiedClassName(Node node, String string, String string2) {
        if (node.getNodeType() == 2) {
            node.setNodeValue(string2);
        } else if (node.getNodeType() == 1) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                String string3;
                Node node2 = nodeList.item(n);
                if (node2.getNodeType() == 3 && (string3 = node2.getNodeValue()).indexOf(string) != -1) {
                    string3 = string3.replaceAll(string, string2);
                    node2.setNodeValue(string3);
                }
                ++n;
            }
        }
        throw new IllegalArgumentException("SimpleClassJavaInfo is being used with something other than element or attribute");
    }

    public void validate(XmlContext xmlContext, Node node) throws ValidationException {
        if (this.getErrorLevel() == 2) {
            return;
        }
        String string = this.getFullyQualifiedClassName(node);
        String[] stringArray = this.getBaseTypes();
        this._validateClassName(xmlContext, node, string, stringArray, this.getErrorLevel());
    }

    public boolean canGoToDeclaration(XmlContext xmlContext, Node node) {
        String string = this.getFullyQualifiedClassName(node);
        if (this.isBuiltInType(string)) {
            return false;
        }
        return xmlContext.getRefInfoResolver().classExists(xmlContext, string);
    }

    public void validate(XmlContext xmlContext, Node node, Object object) throws ValidationException {
        if (this.getErrorLevel() == 0) {
            this._validateClassName(xmlContext, node, (String)object, this.getBaseTypes(), this.getErrorLevel());
        }
    }

    private void _validateClassName(XmlContext xmlContext, Node node, String string, String[] stringArray, int n) throws ValidationException {
        if (stringArray != null && stringArray.length != 0) {
            this.validateClassName(xmlContext, node, string, n);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (xmlContext.getRefInfoResolver().classMatchesType(xmlContext, string, stringArray[n2])) {
                    return;
                }
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
            String string2 = xmlContext.getTranslatedString("MULTIPLE_BASE_CLASS_NO_MATCH");
            int n3 = n == 0 ? 134 : 135;
            ValidationException validationException = new ValidationException(n3, FastMessageFormat.formatMessage(string2, string, stringBuffer.toString()), node);
            validationException.setRelatedObject((Object)this);
            throw validationException;
        }
        this.validateClassName(xmlContext, node, string, null, n);
    }
}

