/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.java.JavaInfo;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class MultipleClassJavaInfo
extends JavaInfo {
    private String _classType;
    private int _errorLevel;

    protected abstract String[] getFullyQualifiedClassNames(String var1);

    public abstract void setFullyQualifiedClassName(Node var1, String var2, String var3);

    public MultipleClassJavaInfo() {
        this(null, 2);
    }

    public MultipleClassJavaInfo(String string) {
        this(string, 2);
    }

    public MultipleClassJavaInfo(String string, int n) {
        this._classType = string;
        this._errorLevel = n;
    }

    public String getBaseType() {
        return this._classType;
    }

    public int getErrorLevel() {
        return this._errorLevel;
    }

    public void validate(XmlContext xmlContext, Node node) throws ValidationException {
        if (this.getErrorLevel() == 2) {
            return;
        }
        String string = this._getNodeValue(node);
        if (string == null) {
            return;
        }
        String[] stringArray = this.getFullyQualifiedClassNames(string);
        this._validateNames(xmlContext, node, stringArray, this.getBaseType());
    }

    public boolean canGoToDeclaration(XmlContext xmlContext, Node node) {
        return false;
    }

    public void validate(XmlContext xmlContext, Node node, Object object) throws ValidationException {
        if (this.getErrorLevel() == 0) {
            this._validateNames(xmlContext, node, this.getFullyQualifiedClassNames((String)object), this.getBaseType());
        }
    }

    public final String[] getFullyQualifiedClassNames(Node node) {
        String string = this._getNodeValue(node);
        if (string == null) {
            return null;
        }
        return this.getFullyQualifiedClassNames(string);
    }

    private void _validateNames(XmlContext xmlContext, Node node, String[] stringArray, String string) throws ValidationException {
        if (stringArray == null || stringArray.length == 0) {
            String string2 = xmlContext.getTranslatedString("MULTIPLE_CLASS_EMPTY");
            int n = this.getErrorLevel() == 0 ? 130 : 131;
            ValidationException validationException = new ValidationException(n, string2, node);
            validationException.setRelatedObject((Object)this);
            throw validationException;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.validateClassName(xmlContext, node, stringArray[n], string, this.getErrorLevel());
            ++n;
        }
    }

    private String _getNodeValue(Node node) {
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            return DomUtils.getTextNodeValue((Node)node);
        }
        return null;
    }
}

