/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.RefInfoResolver;
import oracle.bali.xml.model.metadata.refinfo.java.SingleClassJavaInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class PropertyJavaInfo
extends SingleClassJavaInfo {
    public abstract String getPropertyName(Node var1);

    public abstract String getPropertyType(XmlContext var1, Node var2);

    public boolean canGoToDeclaration(XmlContext xmlContext, Node node) {
        return xmlContext.getRefInfoResolver().propertyExists(xmlContext, this.getFullyQualifiedClassName(node), this.getPropertyName(node), this.getPropertyType(xmlContext, node));
    }

    public void validate(XmlContext xmlContext, Node node) throws ValidationException {
        String string = this.getPropertyName(node);
        this.validatePropertyName(xmlContext, node, string, this.getErrorLevel());
    }

    public void validate(XmlContext xmlContext, Node node, Object object) throws ValidationException {
        this.validatePropertyName(xmlContext, node, (String)object, this.getErrorLevel());
    }

    protected void validatePropertyName(XmlContext xmlContext, Node node, String string, int n) throws ValidationException {
        if (n == 2) {
            return;
        }
        RefInfoResolver refInfoResolver = xmlContext.getRefInfoResolver();
        String string2 = this.getFullyQualifiedClassName(node);
        this.validateClassName(xmlContext, node, string2, n);
        if (string == null || "".equals(string)) {
            String string3 = xmlContext.getTranslatedString("PROPERTY_EMPTY");
            int n2 = n == 0 ? 140 : 141;
            ValidationException validationException = new ValidationException(n2, string3, node);
            validationException.setRelatedObject((Object)this);
            throw validationException;
        }
        if (!this.isDatabound(xmlContext, node) && !refInfoResolver.propertyExists(xmlContext, string2, string, this.getPropertyType(xmlContext, node))) {
            String string4 = xmlContext.getTranslatedString("PROPERTY_NOT_FOUND");
            int n3 = n == 0 ? 142 : 143;
            ValidationException validationException = new ValidationException(n3, FastMessageFormat.formatMessage(string4, string, string2), node);
            validationException.setRelatedObject((Object)this);
            throw validationException;
        }
    }
}

