/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.java;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.java.SingleClassJavaInfo;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleClassJavaInfo
extends SingleClassJavaInfo {
    private String _classType;
    private int _errorLevel;

    public SimpleClassJavaInfo() {
        this(null, 2);
    }

    public SimpleClassJavaInfo(String string) {
        this(string, 2);
    }

    public SimpleClassJavaInfo(String string, int n) {
        this._classType = string;
        this._errorLevel = n;
    }

    public String getBaseType() {
        return this._classType;
    }

    public int getErrorLevel() {
        return this._errorLevel;
    }

    public String getFullyQualifiedClassName(Node node) {
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            return DomUtils.getTextNodeValue((Node)node);
        }
        throw new IllegalArgumentException("SimpleClassJavaInfo is being used with something other than element or attribute");
    }

    public void setFullyQualifiedClassName(Node node, String string, String string2) {
        if (node.getNodeType() == 2) {
            node.setNodeValue(string2);
        } else if (node.getNodeType() == 1) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                String string3;
                Node node2 = nodeList.item(n);
                if (node2.getNodeType() == 3 && (string3 = node2.getNodeValue()).indexOf(string) != -1) {
                    string3 = string3.replaceAll(string, string2);
                    node2.setNodeValue(string3);
                }
                ++n;
            }
        } else {
            throw new IllegalArgumentException("SimpleClassJavaInfo is being used with something other than element or attribute");
        }
    }

    public void validate(XmlContext xmlContext, Node node) throws ValidationException {
        if (this.getErrorLevel() == 2) {
            return;
        }
        String string = this.getFullyQualifiedClassName(node);
        this.validateClassName(xmlContext, node, string, this.getBaseType(), this.getErrorLevel());
    }

    public boolean canGoToDeclaration(XmlContext xmlContext, Node node) {
        String string = this.getFullyQualifiedClassName(node);
        if (this.isBuiltInType(string)) {
            return false;
        }
        return xmlContext.getRefInfoResolver().classExists(xmlContext, string);
    }

    public void validate(XmlContext xmlContext, Node node, Object object) throws ValidationException {
        if (this.getErrorLevel() == 0) {
            this.validateClassName(xmlContext, node, (String)object, this.getBaseType(), this.getErrorLevel());
        }
    }
}

