/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.uri;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.uri.URIInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public class ExternalURLInfo
extends URIInfo {
    public ExternalURLInfo() {
    }

    public String getURL(Node node) {
        return ExternalURLInfo.__getValue(node);
    }

    public ExternalURLInfo(int n) {
        super(n);
    }

    public void validate(XmlContext xmlContext, Node node) throws ValidationException {
        this._validate(xmlContext, node, this.getURL(node));
    }

    public void validate(XmlContext xmlContext, Node node, Object object) throws ValidationException {
        this._validate(xmlContext, node, this.__convertToString(object));
    }

    public boolean canGoToDeclaration(XmlContext xmlContext, Node node) {
        return xmlContext.getRefInfoResolver().uriExists(xmlContext, null, this.getURL(node));
    }

    public void goToDeclaration(XmlContext xmlContext, Node node) {
        xmlContext.getRefInfoResolver().goToDeclaration(xmlContext, node, this);
    }

    private void _validate(XmlContext xmlContext, Node node, String string) throws ValidationException {
        if (string == null || "".equals(string)) {
            String string2 = xmlContext.getTranslatedString("URI_EMPTY");
            throw new ValidationException(200, string2, node);
        }
        if (!this.isDatabound(xmlContext, node) && !xmlContext.getRefInfoResolver().uriExists(xmlContext, null, string)) {
            String string3 = xmlContext.getTranslatedString("EXTERNAL_URI_NOT_FOUND_FORMAT");
            throw new ValidationException(200, FastMessageFormat.formatMessage(string3, string), node);
        }
    }
}

