/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.uri;

import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.uri.RootRelativeURIInfo;
import oracle.bali.xml.model.metadata.refinfo.uri.URIInfo;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class MultiplexingURIInfo
extends URIInfo {
    protected MultiplexingURIInfo(int n) {
        super(n);
    }

    public void validate(XmlContext xmlContext, Node node) throws ValidationException {
        this._validate(xmlContext, node, MultiplexingURIInfo.__getValue(node));
    }

    public void validate(XmlContext xmlContext, Node node, Object object) throws ValidationException {
        this._validate(xmlContext, node, this.__convertToString(object));
    }

    public boolean canGoToDeclaration(XmlContext xmlContext, Node node) {
        URIInfo[] uRIInfoArray = this.getURIInfos();
        int n = 0;
        while (n < uRIInfoArray.length) {
            if (uRIInfoArray[n].canGoToDeclaration(xmlContext, node)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void goToDeclaration(XmlContext xmlContext, Node node) {
        URIInfo[] uRIInfoArray = this.getURIInfos();
        int n = 0;
        while (n < uRIInfoArray.length) {
            if (uRIInfoArray[n].canGoToDeclaration(xmlContext, node)) {
                uRIInfoArray[n].goToDeclaration(xmlContext, node);
                return;
            }
            ++n;
        }
    }

    protected abstract URIInfo[] getURIInfos();

    private void _validate(XmlContext xmlContext, Node node, String string) throws ValidationException {
        if (string == null || "".equals(string)) {
            String string2 = xmlContext.getTranslatedString("URI_EMPTY");
            throw new ValidationException(200, string2, node);
        }
        if (!this.isDatabound(xmlContext, node)) {
            URIInfo[] uRIInfoArray = this.getURIInfos();
            ValidationException validationException = null;
            int n = 0;
            while (n < uRIInfoArray.length) {
                try {
                    if (uRIInfoArray[n] instanceof RootRelativeURIInfo) {
                        RootRelativeURIInfo rootRelativeURIInfo = (RootRelativeURIInfo)uRIInfoArray[n];
                        rootRelativeURIInfo.__validate(xmlContext, node, rootRelativeURIInfo.getRootURL(xmlContext), string);
                    } else {
                        uRIInfoArray[n].validate(xmlContext, node, string);
                    }
                    validationException = null;
                    break;
                }
                catch (ValidationException validationException2) {
                    if (validationException == null) {
                        validationException = validationException2;
                    }
                    ++n;
                }
            }
            if (validationException != null) {
                throw validationException;
            }
        }
    }
}

