/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.metadata.refinfo.uri;

import java.net.URI;
import java.net.URL;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.refinfo.RefInfo;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public abstract class URIInfo
extends RefInfo {
    static final int _URI_MISSING = 200;
    private int _errorType;

    public int getErrorLevel() {
        return this._errorType;
    }

    protected URIInfo() {
        this(2);
    }

    protected URIInfo(int n) {
        this._errorType = n;
    }

    public static String __getValue(Node node) {
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            return DomUtils.getTextNodeValue((Node)node);
        }
        return null;
    }

    void __validate(XmlContext xmlContext, Node node, String string, String string2) throws ValidationException {
        if (string2 == null || "".equals(string2)) {
            String string3 = xmlContext.getTranslatedString("URI_EMPTY");
            throw new ValidationException(200, string3, node);
        }
        if (!this.isDatabound(xmlContext, node) && !xmlContext.getRefInfoResolver().uriExists(xmlContext, string, string2)) {
            String string4 = xmlContext.getTranslatedString("URI_NOT_FOUND_FORMAT");
            throw new ValidationException(200, FastMessageFormat.formatMessage(string4, string2, string), node);
        }
    }

    String __convertToString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof URI) {
            return ((URI)object).toString();
        }
        if (object instanceof URL) {
            return ((URL)object).toExternalForm();
        }
        return object.toString();
    }
}

