/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.misc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.SimpleCollapseWhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ConstrainingFacet;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GrammarBasedWhitespaceHandler
extends WhitespaceHandler {
    private final XmlModel _model;
    private final ThreadLocal _elementToElementDefCache;
    private final ThreadLocal _namespaceToGrammar;
    private static final Map _sTypeToModeCache = Collections.synchronizedMap(new WeakHashMap());
    private static final Logger _LOGGER = Logger.getLogger(GrammarBasedWhitespaceHandler.class.getName());
    private static final WhitespaceHandler _BASE = SimpleCollapseWhitespaceHandler.getSimpleCollapseWhitespaceHandler();
    private static final Object _UNSET_VALUE = new Object();

    public GrammarBasedWhitespaceHandler(XmlModel xmlModel) {
        this.$init$();
        this._model = xmlModel;
    }

    public void beginCacheablePeriod() {
        this._elementToElementDefCache.set(new HashMap(27));
        this._namespaceToGrammar.set(new HashMap(10));
    }

    public void endCacheablePeriod() {
        this._elementToElementDefCache.set(null);
        this._namespaceToGrammar.set(null);
    }

    public WhitespaceMode getAttributeContentWhitespaceMode(TreeTraversal treeTraversal, Element element, String string, String string2) {
        Grammar grammar;
        AttributeDef attributeDef = null;
        ElementDef elementDef = this._getElementDef(treeTraversal, element);
        if (elementDef != null) {
            attributeDef = elementDef.getAttributeDefByName(string, string2);
        }
        if (attributeDef == null && (grammar = this._getGrammarForNamespace(string)) != null) {
            attributeDef = grammar.getAttributeDefByName(string2);
        }
        if (attributeDef != null) {
            SimpleType simpleType = attributeDef.getType();
            WhitespaceMode whitespaceMode = this._getMode((Type)simpleType);
            GrammarBasedWhitespaceHandler._log(element, (Type)simpleType, whitespaceMode);
            if (whitespaceMode != null) {
                return whitespaceMode;
            }
        }
        return _BASE.getAttributeContentWhitespaceMode(treeTraversal, element, string, string2);
    }

    protected WhitespaceMode getElementContentWhitespaceModeImpl(TreeTraversal treeTraversal, Element element, WhitespaceMode whitespaceMode) {
        if (whitespaceMode != null) {
            return whitespaceMode;
        }
        ElementDef elementDef = this._getElementDef(treeTraversal, element);
        if (elementDef != null) {
            Type type = elementDef.getType();
            WhitespaceMode whitespaceMode2 = this._getMode(type);
            GrammarBasedWhitespaceHandler._log(element, type, whitespaceMode2);
            if (whitespaceMode2 != null) {
                return whitespaceMode2;
            }
            if (type instanceof SimpleType) {
                return this.getDefaultModeForSimpleTypeElements();
            }
            if (type instanceof ComplexType) {
                return this.getDefaultModeForComplexTypeElements();
            }
        }
        return _BASE.getElementContentWhitespaceMode(treeTraversal, element);
    }

    protected WhitespaceMode getDefaultModeForSimpleTypeElements() {
        return WhitespaceMode.MODE_COLLAPSE;
    }

    protected WhitespaceMode getDefaultModeForComplexTypeElements() {
        return WhitespaceMode.MODE_COLLAPSE;
    }

    private ElementDef _getElementDef(TreeTraversal treeTraversal, Element element) {
        ElementDef elementDef;
        String string = element.getNamespaceURI();
        Grammar grammar = this._getGrammarForNamespace(string);
        if (grammar == null) {
            return null;
        }
        Map map = this._getElementToElementDefCache();
        Object v = map.get(element);
        if (v == null) {
            elementDef = this._getElementDefDirectly(treeTraversal, grammar, element);
            if (map != Collections.EMPTY_MAP) {
                if (elementDef == null) {
                    map.put(element, _UNSET_VALUE);
                } else {
                    map.put(element, elementDef);
                }
            }
        } else {
            elementDef = v == _UNSET_VALUE ? null : (ElementDef)v;
        }
        return elementDef;
    }

    private ElementDef _getElementDefDirectly(TreeTraversal treeTraversal, Grammar grammar, Element element) {
        ElementDef elementDef;
        ElementDef elementDef2;
        String string = element.getNamespaceURI();
        String string2 = DomUtils.getLocalName((Node)element);
        Node node = treeTraversal.getParentNode((Node)element);
        if (DomUtils.isElement((Node)node) && (elementDef2 = this._getElementDef(treeTraversal, (Element)node)) != null && (elementDef = elementDef2.getElementDefByName(string, string2)) != null) {
            return elementDef;
        }
        if (grammar != null) {
            return grammar.getElementDefByName(string2);
        }
        return null;
    }

    private Map _getElementToElementDefCache() {
        Object t = this._elementToElementDefCache.get();
        if (t == null) {
            return Collections.EMPTY_MAP;
        }
        return (Map)t;
    }

    private Grammar _getGrammarForNamespace(String string) {
        Object t = this._namespaceToGrammar.get();
        if (t == null) {
            return this._provider().getGrammarForNamespace(string);
        }
        Map map = (Map)t;
        Object v = map.get(string);
        if (v == null) {
            Grammar grammar = this._provider().getGrammarForNamespace(string);
            if (grammar == null) {
                map.put(string, _UNSET_VALUE);
            } else {
                map.put(string, grammar);
            }
            return grammar;
        }
        if (v == _UNSET_VALUE) {
            return null;
        }
        return (Grammar)v;
    }

    private GrammarProvider _provider() {
        return this._model.getContext().getGrammarProvider();
    }

    private WhitespaceMode _getMode(Type type) {
        Object v = _sTypeToModeCache.get(type);
        if (v == _UNSET_VALUE) {
            return null;
        }
        if (v != null) {
            return (WhitespaceMode)v;
        }
        WhitespaceMode whitespaceMode = this._getModeDirectly(type);
        if (whitespaceMode == null) {
            _sTypeToModeCache.put(type, _UNSET_VALUE);
        } else {
            _sTypeToModeCache.put(type, whitespaceMode);
        }
        return whitespaceMode;
    }

    private WhitespaceMode _getModeDirectly(Type type) {
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            ConstrainingFacet constrainingFacet = TypeUtils.findFacet((SimpleType)simpleType, (int)12);
            if (constrainingFacet != null) {
                String string = constrainingFacet.getConstraintValue();
                if ("preserve".equals(string)) {
                    return WhitespaceMode.MODE_PRESERVE;
                }
                if ("replace".equals(string)) {
                    return WhitespaceMode.MODE_REPLACE;
                }
                if ("collapse".equals(string)) {
                    return WhitespaceMode.MODE_COLLAPSE;
                }
            }
        } else if (type instanceof ComplexType) {
            switch (type.getVariety()) {
                case 3: 
                case 6: {
                    return WhitespaceMode.MODE_COLLAPSE;
                }
                case 5: {
                    SimpleType simpleType = TypeUtils.getSimpleTypeAncestor((Type)type);
                    if (simpleType == null) break;
                    return this._getMode((Type)simpleType);
                }
            }
        }
        return null;
    }

    private static void _log(Element element, Type type, WhitespaceMode whitespaceMode) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Grammar-based whitespace handler: mode={0} type={1} elem={2}", new Object[]{whitespaceMode, type.getName(), element.getNodeName()});
        }
    }

    void $init$() {
        this._elementToElementDefCache = new ThreadLocal();
        this._namespaceToGrammar = new ThreadLocal();
    }
}

