/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.misc;

import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptionsDecorator;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.automata.AutomataBuilder;
import oracle.bali.xml.grammar.automata.State;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.DomNodeXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlModelBasedTextSyncOptions
extends TextSyncOptionsDecorator {
    private final XmlContext _context;
    private final TextSyncOptions _base;

    public XmlModelBasedTextSyncOptions(XmlContext xmlContext, TextSyncOptions textSyncOptions) {
        if (textSyncOptions == null) {
            textSyncOptions = TextSyncOptions.DEFAULT_TEXT_SYNC_OPTIONS;
        }
        this._context = xmlContext;
        this._base = textSyncOptions;
    }

    public XmlModelBasedTextSyncOptions(XmlContext xmlContext) {
        this(xmlContext, null);
    }

    public boolean prefersWhitespaceInside(Element element) {
        ElementDef elementDef = this._getElementDef(element);
        if (TypeUtils.isSimpleTypeOrComplexTextOnlyElement((GrammarComponent)elementDef)) {
            return false;
        }
        return super.prefersWhitespaceInside(element);
    }

    public boolean useMinimizedForm(Element element) {
        ElementDef elementDef = this._getElementDef(element);
        if (elementDef != null) {
            State state;
            if (TypeUtils.isSimpleTypeOrComplexTextOnlyElement((GrammarComponent)elementDef)) {
                return false;
            }
            ComplexType complexType = (ComplexType)elementDef.getType();
            ContentGroup contentGroup = complexType.getContentGroup();
            if (contentGroup != null && (state = AutomataBuilder.buildAutomata((ContentGroup)contentGroup)) != null && !state.isFinalState()) {
                return false;
            }
        }
        return super.useMinimizedForm(element);
    }

    protected TextSyncOptions getBaseTextSyncOptions() {
        return this._base;
    }

    protected final XmlContext getXmlContext() {
        return this._context;
    }

    private ElementDef _getElementDef(Element element) {
        XmlModel xmlModel = this._context.getSourceModel();
        if (xmlModel != null) {
            return (ElementDef)xmlModel.getXmlMetadataResolver().getGrammarComponent(element);
        }
        GrammarResolver grammarResolver = this._context.getGrammarResolver();
        XmlKey xmlKey = DomNodeXmlKey.createImmutableXmlKey((GrammarResolver)grammarResolver, (Node)element);
        return (ElementDef)GrammarUtils.getGrammarComponent((GrammarResolver)grammarResolver, (XmlKey)xmlKey);
    }
}

