/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.resource;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bali.share.collection.CompoundEnumeration;
import oracle.bali.xml.share.NoDuplicatesEnumeration;

public final class PaternalResourceBundle
extends ResourceBundle {
    private static final int _AVERAGE_RESOURCE_SIZE = 101;
    private static final ResourceBundle[] _EMPTY_ARRAY = new ResourceBundle[0];
    private String[] _bundleNames;
    private Locale _locale;
    private transient Enumeration _keys;
    private transient ResourceBundle[] _bundles;
    private transient HashMap _valueCache;

    public PaternalResourceBundle(String[] stringArray) {
        this(stringArray, null);
    }

    public PaternalResourceBundle(ResourceBundle[] resourceBundleArray) {
        if (resourceBundleArray == null || resourceBundleArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this._bundles = this._flattenBundles(resourceBundleArray);
    }

    public PaternalResourceBundle(String[] stringArray, Locale locale) {
        int n = stringArray.length;
        if (stringArray == null || n == 0) {
            throw new IllegalArgumentException();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        this._bundleNames = stringArray;
        this._locale = locale;
    }

    public Enumeration getKeys() {
        int n;
        if (this._bundles == null) {
            this._createBundles();
        }
        if ((n = this._bundles.length) > 1) {
            CompoundEnumeration compoundEnumeration = new CompoundEnumeration(this._bundles[0].getKeys(), this._bundles[1].getKeys());
            int n2 = 2;
            while (n2 < n) {
                compoundEnumeration = new CompoundEnumeration((Enumeration)compoundEnumeration, this._bundles[n2].getKeys());
                ++n2;
            }
            return new NoDuplicatesEnumeration((Enumeration)compoundEnumeration);
        }
        if (n == 1) {
            return this._bundles[0].getKeys();
        }
        return null;
    }

    public String toString() {
        if (this._bundles == null) {
            this._createBundles();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Paternal-bundle(");
        int n = 0;
        while (n < this._bundles.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this._bundles[n]);
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected Object handleGetObject(String string) throws MissingResourceException {
        int n;
        if (this._bundles == null) {
            this._createBundles();
        }
        if ((n = this._bundles.length) > 1) {
            Object object;
            if (this._valueCache == null) {
                this._createValueCache(n);
            }
            if ((object = this._valueCache.get(string)) == null) {
                int n2 = 0;
                while (true) {
                    try {
                        object = this._bundles[n2].getObject(string);
                        this._valueCache.put(string, object);
                    }
                    catch (MissingResourceException missingResourceException) {
                        if (++n2 != n) continue;
                        throw missingResourceException;
                    }
                    break;
                }
            }
            return object;
        }
        if (n == 1) {
            return this._bundles[0].getObject(string);
        }
        return null;
    }

    private ResourceBundle[] _flattenBundles(ResourceBundle[] resourceBundleArray) {
        int n = resourceBundleArray.length;
        LinkedHashSet linkedHashSet = new LinkedHashSet(2 * n);
        this._flattenBundles(resourceBundleArray, linkedHashSet);
        return linkedHashSet.toArray(_EMPTY_ARRAY);
    }

    private void _flattenBundles(ResourceBundle[] resourceBundleArray, LinkedHashSet linkedHashSet) {
        int n = resourceBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceBundle resourceBundle = resourceBundleArray[n2];
            if (resourceBundle != null) {
                if (resourceBundle instanceof PaternalResourceBundle) {
                    PaternalResourceBundle paternalResourceBundle = (PaternalResourceBundle)resourceBundle;
                    this._flattenBundles(paternalResourceBundle._bundles, linkedHashSet);
                } else {
                    linkedHashSet.add(resourceBundle);
                }
            }
            ++n2;
        }
    }

    private void _createBundles() {
        int n = this._bundleNames.length;
        ResourceBundle[] resourceBundleArray = new ResourceBundle[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                resourceBundleArray[n2] = PaternalResourceBundle.getBundle(this._bundleNames[n2], this._locale);
            }
            catch (MissingResourceException missingResourceException) {
                resourceBundleArray[n2] = null;
            }
            ++n2;
        }
        this._bundles = this._flattenBundles(resourceBundleArray);
    }

    private void _createValueCache(int n) {
        if (n < 2) {
            throw new IllegalArgumentException();
        }
        this._valueCache = new HashMap(101 * n);
    }
}

