/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.task;

import java.util.logging.Logger;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;

public abstract class SafeCheckAndPerformTask {
    protected abstract boolean requiresTask(AbstractModel var1);

    protected abstract void performTask(AbstractModel var1) throws XmlCommitException;

    protected void handleCommitThrowable(Throwable throwable, AbstractModel abstractModel) {
        Logger logger = Logger.getLogger(SafeCheckAndPerformTask.class.getName());
        logger.throwing(throwable.getLocalizedMessage(), "SafeCheckAndPerformTask::run", throwable);
    }

    public final boolean run(AbstractModel abstractModel, String string) {
        abstractModel.acquireReadLock();
        try {
            if (!this.requiresTask(abstractModel)) {
                boolean bl = false;
                abstractModel.releaseReadLock();
                return bl;
            }
        }
        finally {
            abstractModel.releaseReadLock();
        }
        abstractModel.startTransaction(string);
        try {
            if (!this.requiresTask(abstractModel)) {
                boolean bl = false;
                return bl;
            }
            this.performTask(abstractModel);
            abstractModel.commitTransaction();
            boolean bl = true;
            return bl;
        }
        catch (ThreadDeath threadDeath) {
            abstractModel.rollbackTransaction();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.handleCommitThrowable(throwable, abstractModel);
            abstractModel.rollbackTransaction();
            return false;
        }
    }
}

