/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.task;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.javatools.logging.LogUtils;

public abstract class StandardTransactionTask {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Map _sAlreadyLoggedExceptions;

    public final boolean run(AbstractModel abstractModel) {
        try {
            boolean bl = this.runThrowingXCE(abstractModel);
            return bl;
        }
        catch (XmlCommitException xmlCommitException) {
            boolean bl = false;
            return bl;
        }
    }

    public final boolean runThrowingXCE(AbstractModel abstractModel) throws XmlCommitException {
        block23: {
            if (abstractModel == null) {
                throw new IllegalArgumentException("null model");
            }
            abstractModel.acquireReadLock();
            try {
                if (!this.requiresTask(abstractModel)) {
                    boolean bl = false;
                    abstractModel.releaseReadLock();
                    return bl;
                }
            }
            finally {
                abstractModel.releaseReadLock();
            }
            AbstractModel abstractModel2 = this.__getWrapperTransactionModel(abstractModel);
            String string = this.getTransactionNameWithoutModelAccess();
            abstractModel2.startTransaction(string);
            try {
                if (this.requiresTask(abstractModel)) {
                    if (abstractModel == abstractModel2 && this._isOkTxnName(string)) {
                        this.performTask(abstractModel);
                    } else {
                        if (string == null) {
                            string = this.computeTransactionName(abstractModel);
                        }
                        boolean bl = false;
                        if (this._isOkTxnName(string)) {
                            abstractModel.startTransaction(string);
                            try {
                                this.performTask(abstractModel);
                                abstractModel.commitTransaction();
                                bl = true;
                            }
                            finally {
                                if (!bl) {
                                    abstractModel.rollbackTransaction();
                                }
                            }
                        }
                    }
                }
                this.__commitWrapperTransaction(abstractModel2);
                boolean bl = true;
                return bl;
            }
            catch (CancelTransactionException cancelTransactionException) {
                abstractModel2.rollbackTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                abstractModel2.rollbackTransaction();
                boolean bl = this.handleThrownXmlCommitException(abstractModel, xmlCommitException, string);
                if (bl) {
                    throw xmlCommitException;
                }
            }
            catch (RuntimeException runtimeException) {
                abstractModel2.rollbackTransaction();
                boolean bl = this.handleThrownRuntimeException(abstractModel, runtimeException, string);
                if (bl) {
                    throw runtimeException;
                }
            }
            catch (Error error) {
                abstractModel2.rollbackTransaction();
                boolean bl = this.handleThrownError(abstractModel, error, string);
                if (!bl) break block23;
                throw error;
            }
        }
        return false;
    }

    protected String getTransactionNameWithoutModelAccess() {
        return null;
    }

    protected String computeTransactionName(AbstractModel abstractModel) {
        return null;
    }

    protected abstract void performTask(AbstractModel var1) throws XmlCommitException;

    protected boolean requiresTask(AbstractModel abstractModel) {
        return true;
    }

    protected boolean handleThrownXmlCommitException(AbstractModel abstractModel, XmlCommitException xmlCommitException, String string) {
        this.logException(abstractModel, xmlCommitException, string, Level.FINE);
        return true;
    }

    protected boolean handleThrownError(AbstractModel abstractModel, Error error, String string) {
        this.logException(abstractModel, error, string, Level.WARNING);
        return true;
    }

    protected boolean handleThrownRuntimeException(AbstractModel abstractModel, RuntimeException runtimeException, String string) {
        this.logException(abstractModel, runtimeException, string, Level.WARNING);
        return true;
    }

    static {
        $assertionsDisabled = StandardTransactionTask.class.desiredAssertionStatus() ^ true;
        _sAlreadyLoggedExceptions = Collections.synchronizedMap(new WeakHashMap());
    }

    protected void logException(AbstractModel abstractModel, Throwable throwable, String string, Level level) {
        level = Level.WARNING;
        Logger logger = this.getLogger(abstractModel);
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        String string2 = "";
        Level level2 = _sAlreadyLoggedExceptions.put(throwable, level);
        if (level2 != null && level2.intValue() >= level.intValue()) {
            throwable = null;
            string2 = "(exception previously logged)";
        }
        LogUtils.log((Logger)logger, (Level)level, (String)"Exception in task {0} on model {1}; txn name={2} {3}", (Object[])new Object[]{this, abstractModel, string, string2}, (Throwable)throwable);
    }

    protected Logger getLogger(AbstractModel abstractModel) {
        return Logger.getLogger(this.getClass().getName());
    }

    protected final void cancelTask() throws CancelTransactionException {
        throw new CancelTransactionException();
    }

    AbstractModel __getWrapperTransactionModel(AbstractModel abstractModel) {
        return abstractModel;
    }

    void __commitWrapperTransaction(AbstractModel abstractModel) throws XmlCommitException {
        abstractModel.commitTransaction();
    }

    boolean __isNullNameOK() {
        return false;
    }

    private boolean _isOkTxnName(String string) {
        return string != null || this.__isNullNameOK();
    }

    protected StandardTransactionTask() {
    }

    private static class CancelTransactionException
    extends RuntimeException {
    }
}

