/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.view.FilteredView;
import org.w3c.dom.Node;

public abstract class AbstractMultipleRootFilteredView
extends FilteredView {
    private Set _roots;
    private final Map _cache;
    private static final Short _ACCEPT = new Short(1);
    private static final Short _SKIP = new Short(3);

    protected abstract Set updateRootNodes(XmlModelEvent var1, Set var2);

    protected short acceptNodeInSubtree(Node node) {
        return 1;
    }

    protected XmlModelEvent transformModelEventHook(XmlModelEvent xmlModelEvent) {
        if (xmlModelEvent.isDomTreeChanged()) {
            Set set = this._roots;
            this._roots = this.updateRootNodes(xmlModelEvent, set);
            if (!this._equal(set, this._roots) || xmlModelEvent.isDomStructureChanged()) {
                this._clearCache();
            }
        }
        return super.transformModelEventHook(xmlModelEvent);
    }

    protected final short acceptNode(Node node) {
        if (this._roots == null) {
            return 2;
        }
        short s = this._acceptNodeUnderSubtree(node);
        if (s != 1 || this._isRootOrDocNode(node)) {
            return s;
        }
        return this.acceptNodeInSubtree(node);
    }

    protected void baseModelAttached() {
        super.baseModelAttached();
        this._roots = this.updateRootNodes(null, this._roots);
        this._clearCache();
    }

    static boolean __isDecendentOfRootNode(Set set, Node node) {
        for (Node node2 : set) {
            if (!DomUtils.isDescendant((Node)node, (Node)node2)) continue;
            return true;
        }
        return false;
    }

    private boolean _isRootOrDocNode(Node node) {
        return node.getNodeType() == 9 || this._roots != null && this._roots.contains(node);
    }

    private boolean _equal(Set set, Set set2) {
        if (set == set2) {
            return true;
        }
        if (set != null && set2 != null) {
            return set.equals(set2);
        }
        return false;
    }

    private short _acceptNodeUnderSubtree(Node node) {
        Short s;
        Short s2 = (Short)this._cache.get(node);
        if (s2 != null) {
            s = s2;
        } else {
            s = this._isRootOrDocNode(node) ? _ACCEPT : (this._isAncestorOfRootNode(node) ? _SKIP : (AbstractMultipleRootFilteredView.__isDecendentOfRootNode(this._roots, node) ? _ACCEPT : _SKIP));
            this._cache.put(node, s);
        }
        return s;
    }

    private boolean _isAncestorOfRootNode(Node node) {
        for (Node node2 : this._roots) {
            if (!DomUtils.isDescendant((Node)node2, (Node)node)) continue;
            return true;
        }
        return false;
    }

    private void _clearCache() {
        this._cache.clear();
    }

    void $init$() {
        this._roots = null;
        this._cache = new HashMap();
    }

    public AbstractMultipleRootFilteredView() {
        this.$init$();
    }
}

