/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.view.FilteredView;
import org.w3c.dom.Node;

public abstract class AbstractSubtreeFilteredView
extends FilteredView {
    private Node _root;
    private final Map _cache;
    private static final Short _ACCEPT = new Short(1);
    private static final Short _SKIP = new Short(3);
    private static final Short _REJECT = new Short(2);

    protected abstract Node updateRootNode(XmlModelEvent var1, Node var2);

    protected short acceptNodeInSubtree(Node node) {
        return 1;
    }

    protected XmlModelEvent transformModelEventHook(XmlModelEvent xmlModelEvent) {
        if (xmlModelEvent.isDomTreeChanged()) {
            Node node = this._root;
            this._root = this.updateRootNode(xmlModelEvent, node);
            if (node != this._root || xmlModelEvent.isDomStructureChanged()) {
                this._clearCache();
            }
        }
        return super.transformModelEventHook(xmlModelEvent);
    }

    protected final short acceptNode(Node node) {
        if (this._root == null) {
            return 2;
        }
        short s = this._acceptNodeUnderSubtree(node);
        if (s != 1 || this._isRootOrDocNode(node)) {
            return s;
        }
        return this.acceptNodeInSubtree(node);
    }

    protected void baseModelAttached() {
        super.baseModelAttached();
        this._root = this.updateRootNode(null, this._root);
        this._clearCache();
    }

    private boolean _isRootOrDocNode(Node node) {
        return node == this._root || node.getNodeType() == 9;
    }

    private short _acceptNodeUnderSubtree(Node node) {
        Short s;
        Short s2 = (Short)this._cache.get(node);
        if (s2 != null) {
            s = s2;
        } else {
            s = this._isRootOrDocNode(node) ? _ACCEPT : (DomUtils.isDescendant((Node)this._root, (Node)node) ? _SKIP : (DomUtils.isDescendant((Node)node, (Node)this._root) ? _ACCEPT : _SKIP));
            this._cache.put(node, s);
        }
        return s;
    }

    private void _clearCache() {
        this._cache.clear();
    }

    void $init$() {
        this._root = null;
        this._cache = new HashMap();
    }

    public AbstractSubtreeFilteredView() {
        this.$init$();
    }
}

