/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.view.standalone.StandaloneElement;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.view.FilteredViewTreeTraversal;
import oracle.bali.xml.model.view.SimpleTypeElementFilteredView;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.XmlCreationAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CategorizedView
extends SimpleTypeElementFilteredView {
    private static final String _FAKE_NAMESPACE = "http://xmlns.oracle.com/jdev/bali/xml/model/view/categorized";
    private static final QualifiedName _SHORT_DISPLAY_NAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"shortDisplayName");
    private static final QualifiedName _MEDIUM_DISPLAY_NAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"mediumDisplayName");
    private static final QualifiedName _LONG_DISPLAY_NAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"longDisplayName");
    private static final QualifiedName _SMALL_ICON_NAME = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata", (String)"smallIcon");
    private BeforeTraversal _before = new BeforeTraversal(this);

    public XmlKey getNodeXmlKey(Node node) {
        return this.isCategoryNode(node) ? this._before.getKey(node) : super.getNodeXmlKey(node);
    }

    public DomPosition viewToModel(DomPosition domPosition) {
        if (domPosition == null) {
            return null;
        }
        Node node = domPosition.getTargetNode();
        Node node2 = this.viewToModel(node);
        if (node2 == null) {
            return null;
        }
        if (node2 == node) {
            return domPosition;
        }
        return DomPositionFactory.createDomPosition((Node)node2, (int)domPosition.getRelativePosition());
    }

    public Node viewToModel(Node node) {
        if (node == null) {
            return null;
        }
        if (this.isCategoryNode(node)) {
            return null;
        }
        return node;
    }

    public Collection insertNodes(DomPosition domPosition, String string, Collection collection, boolean bl) throws XmlCommitException {
        Node node = domPosition.getContainerNode();
        if (this.isCategoryNode(node)) {
            Element element = node.getOwnerDocument().getDocumentElement();
            domPosition = DomPositionFactory.inside((Node)element);
        }
        return super.insertNodes(domPosition, string, collection, bl);
    }

    public DomPosition convertInsertionPosition(DomPosition domPosition) {
        Node node;
        if (domPosition != null && (node = domPosition.getTargetNode()) != null && this.isCategoryNode(node)) {
            if (domPosition.isInside()) {
                Node node2 = BeforeTraversal.mav$_getLastChild(this._before, node);
                if (node2 != null) {
                    return DomPositionFactory.createDomPosition((Node)node2, (int)2);
                }
            } else if (domPosition.isBefore()) {
                Node node3 = BeforeTraversal.mav$_getFirstChild(this._before, node);
                if (node3 != null) {
                    return DomPositionFactory.createDomPosition((Node)node3, (int)1);
                }
                Node node4 = BeforeTraversal.mav$_getPreviousFakeChild(this._before, node);
                if (node4 != null) {
                    return this.convertInsertionPosition(DomPositionFactory.createDomPosition((Node)node4, (int)0));
                }
            } else if (domPosition.isBefore()) {
                Node node5 = BeforeTraversal.mav$_getLastChild(this._before, node);
                if (node5 != null) {
                    return DomPositionFactory.createDomPosition((Node)node5, (int)2);
                }
                Node node6 = BeforeTraversal.mav$_getNextFakeChild(this._before, node);
                if (node6 != null) {
                    return this.convertInsertionPosition(DomPositionFactory.createDomPosition((Node)node6, (int)0));
                }
            }
            return DomPositionFactory.createDomPosition((Node)node.getOwnerDocument().getDocumentElement(), (int)0);
        }
        return super.convertInsertionPosition(domPosition);
    }

    public List getExtraContextMenus(DomPosition domPosition) {
        this.acquireReadLock();
        try {
            Selection selection = this.getSelection();
            if (selection.size() != 1) {
                List list = super.getExtraContextMenus(domPosition);
                this.releaseReadLock();
                return list;
            }
            Node node = selection.getFirstSelectedNode();
            if (this.isCategoryNode(node)) {
                List list = this._before.getCreationKeys(node);
                if (list == null) {
                    List list2 = Collections.EMPTY_LIST;
                    this.releaseReadLock();
                    return list2;
                }
                if (list.size() > 0) {
                    XmlKey xmlKey = (XmlKey)list.get(0);
                    XmlCreationAction xmlCreationAction = new XmlCreationAction((AbstractModel)this, domPosition, xmlKey);
                    String string = this.getTranslatedString("INSERT_MENU_FORMAT");
                    String string2 = FastMessageFormat.formatMessage(string, xmlKey.getLocalName());
                    int n = StringUtils.getMnemonicKeyCode((String)string2);
                    string2 = StringUtils.stripMnemonic((String)string2);
                    JMenuItem jMenuItem = null;
                    String string3 = this.getTranslatedString("INSERT_MENU.OVERFLOW_FORMAT");
                    String string4 = FastMessageFormat.formatMessage(string3, string2);
                    XmlCreationAction xmlCreationAction2 = xmlCreationAction;
                    xmlCreationAction2.putValue("Name", string4);
                    xmlCreationAction2.putValue("MnemonicKey", new Integer(n));
                    jMenuItem = UIUtils.createMenuItem((Action)xmlCreationAction2);
                    List<JMenuItem> list3 = Collections.singletonList(jMenuItem);
                    this.releaseReadLock();
                    return list3;
                }
            }
            List list = super.getExtraContextMenus(domPosition);
            this.releaseReadLock();
            return list;
        }
        catch (Throwable throwable) {
            this.releaseReadLock();
            throw throwable;
        }
    }

    protected abstract List getCategories();

    protected abstract String getCategory(Node var1);

    protected abstract List getCreationKeys(String var1);

    protected abstract boolean isRootNode(XmlKey var1, Node var2);

    protected Object getCategoryMetadataItem(QualifiedName qualifiedName, String string) {
        if (_SHORT_DISPLAY_NAME.equals((Object)qualifiedName)) {
            return this.getCategoryShortDisplayName(string);
        }
        if (_MEDIUM_DISPLAY_NAME.equals((Object)qualifiedName)) {
            return this.getCategoryMediumDisplayName(string);
        }
        if (_LONG_DISPLAY_NAME.equals((Object)qualifiedName)) {
            return this.getCategoryMediumDisplayName(string);
        }
        if (_SMALL_ICON_NAME.equals((Object)qualifiedName)) {
            return this.getCategorySmallIcon(string);
        }
        return null;
    }

    protected String getCategoryShortDisplayName(String string) {
        return string;
    }

    protected String getCategoryMediumDisplayName(String string) {
        return string;
    }

    protected String getCategoryLongDisplayName(String string) {
        return string;
    }

    protected String getCategorySmallIcon(String string) {
        return null;
    }

    protected final boolean isCategoryNode(Node node) {
        return this._before.isFake(node);
    }

    protected final boolean isCategoryNodeKey(XmlKey xmlKey) {
        return this._before.isFake(xmlKey);
    }

    protected XmlMetadataResolver createXmlMetadataResolver(MetadataEvaluator metadataEvaluator) {
        return new CategorizedMetadataResolver(metadataEvaluator, this);
    }

    protected final MetadataEvaluator createMetadataEvaluator() {
        return new CategorizedMetadataEvaluator(null);
    }

    protected final TreeTraversal createTreeTraversal() {
        return new Traversal(this, this._before);
    }

    protected final short acceptNode(Node node) {
        if (this.isCategoryNode(node)) {
            return 1;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: {
                return 2;
            }
        }
        if (this.getXmlMetadataResolver().isHidden(node)) {
            return 2;
        }
        return super.acceptNode(node);
    }

    protected final XmlModelEvent transformModelEventHook(XmlModelEvent xmlModelEvent) {
        Node node = xmlModelEvent.getChangeRoot();
        PropertyChange propertyChange = xmlModelEvent.getDomDocumentPropertyChange();
        if (propertyChange != null) {
            this._before.updateCache(node, true);
        } else if (node != null && xmlModelEvent.isDomStructureChanged()) {
            this._before.updateCache(node, false);
        }
        return super.transformModelEventHook(xmlModelEvent);
    }

    final boolean __isRootNode(Node node) {
        return this.isRootNode(this.getNodeXmlKey(node), node);
    }

    private static final class Traversal
    extends FilteredViewTreeTraversal {
        private TreeTraversal _before;

        public Traversal(CategorizedView categorizedView, TreeTraversal treeTraversal) {
            super(categorizedView);
            this._before = treeTraversal;
        }

        protected TreeTraversal getBeforeTraversal() {
            return this._before;
        }
    }

    private static final class BeforeTraversal
    extends TreeTraversal {
        private List _categories;
        private List _children;
        private HashMap _keys;
        private HashMap _creationKeys;
        private HashMap _childNameToIndex;
        private HashMap _childIsCategorized;
        private HashMap _childToFakeParent;
        private HashMap _fakeChildToFakeChildChildren;
        private CategorizedView _view;

        public BeforeTraversal(XmlView xmlView) {
            this.$init$();
            this._view = (CategorizedView)xmlView;
        }

        public void dispose() {
            this._view = null;
        }

        public boolean isFake(Node node) {
            return node == null ? false : CategorizedView._FAKE_NAMESPACE.equals(node.getNamespaceURI());
        }

        public boolean isFake(XmlKey xmlKey) {
            return xmlKey == null ? false : CategorizedView._FAKE_NAMESPACE.equals(xmlKey.getNamespace());
        }

        public XmlKey getKey(Node node) {
            this._createFakeChildren(node);
            return (XmlKey)this._keys.get(node);
        }

        public List getCreationKeys(Node node) {
            List list;
            this._createFakeChildren(node);
            if (this._creationKeys == null) {
                this._creationKeys = new HashMap(this._categories.size());
            }
            if ((list = (List)this._creationKeys.get(node)) == null) {
                list = this._view.getCreationKeys(DomUtils.getLocalName((Node)node));
                this._creationKeys.put(node, list);
            }
            return list == Collections.EMPTY_LIST ? null : list;
        }

        public Node getParentNode(Node node) {
            if (this.isFake(node)) {
                return node.getOwnerDocument().getDocumentElement();
            }
            if (DomUtils.asElement((Node)node) != null && node.getParentNode() == node.getOwnerDocument().getDocumentElement()) {
                return this._findParent(node);
            }
            return node.getParentNode();
        }

        public Node getFirstChild(Node node) {
            if (this.isFake(node)) {
                return this._getFirstChild(node);
            }
            if (this._view.__isRootNode(node)) {
                return this._getFirstFakeChild(node);
            }
            return node.getFirstChild();
        }

        public Node getLastChild(Node node) {
            if (this.isFake(node)) {
                return this._getLastChild(node);
            }
            if (this._view.__isRootNode(node)) {
                return this._getLastFakeChild(node);
            }
            return node.getLastChild();
        }

        public Node getNextSibling(Node node) {
            if (this.isFake(node)) {
                return this._getNextFakeChild(node);
            }
            if (node.getParentNode() == node.getOwnerDocument().getDocumentElement()) {
                return this._getNextChild(node);
            }
            return node.getNextSibling();
        }

        public Node getPreviousSibling(Node node) {
            if (this.isFake(node)) {
                return this._getPreviousFakeChild(node);
            }
            if (node.getParentNode() == node.getOwnerDocument().getDocumentElement()) {
                return this._getPreviousChild(node);
            }
            return node.getPreviousSibling();
        }

        public void updateCache(Node node, boolean bl) {
            this._fakeChildToFakeChildChildren.clear();
            this._childToFakeParent.clear();
            this._childIsCategorized.clear();
            if (bl) {
                if (this._children != null) {
                    this._children.clear();
                    this._keys.clear();
                    this._childNameToIndex.clear();
                }
                this._children = null;
            }
        }

        private void _createFakeChildren(Node node) {
            if (this._children == null) {
                this._fakeChildToFakeChildChildren.clear();
                List list = this._view.getCategories();
                if (list == null) {
                    throw new IllegalArgumentException("No categories!");
                }
                this._categories = Collections.unmodifiableList(list);
                int n = this._categories.size();
                this._children = new ArrayList(n);
                this._keys = new HashMap(n);
                Document document = node.getOwnerDocument();
                int n2 = 0;
                for (String string : this._categories) {
                    StandaloneElement standaloneElement = new StandaloneElement(document, CategorizedView._FAKE_NAMESPACE, null, string);
                    this._children.add(standaloneElement);
                    this._keys.put(standaloneElement, ImmutableXmlKey.createElementKey((QualifiedName)QualifiedName.getQualifiedName((String)CategorizedView._FAKE_NAMESPACE, (String)string)).intern());
                    this._childNameToIndex.put(string, IntegerUtils.getInteger((int)n2++));
                }
            }
        }

        private Node _getFirstFakeChild(Node node) {
            this._createFakeChildren(node);
            return (Node)this._children.get(0);
        }

        private Node _getLastFakeChild(Node node) {
            this._createFakeChildren(node);
            return (Node)this._children.get(this._children.size() - 1);
        }

        private Node _getNextFakeChild(Node node) {
            this._createFakeChildren(node);
            Integer n = (Integer)this._childNameToIndex.get(DomUtils.getLocalName((Node)node));
            int n2 = n;
            return n2 == this._children.size() - 1 ? null : (Node)this._children.get(n2 + 1);
        }

        private Node _getPreviousFakeChild(Node node) {
            this._createFakeChildren(node);
            Integer n = (Integer)this._childNameToIndex.get(DomUtils.getLocalName((Node)node));
            int n2 = n;
            return n2 == 0 ? null : (Node)this._children.get(n2 - 1);
        }

        private Node _findParent(Node node) {
            this._createFakeChildren(node);
            Object object = this._childToFakeParent.get(node);
            if (object == null) {
                String string = this._view.getCategory(node);
                int n = string == null ? -1 : this._categories.indexOf(string);
                object = n == -1 ? node.getParentNode() : this._children.get(n);
                this._childToFakeParent.put(node, object);
            }
            return (Node)object;
        }

        private Node _getFirstChild(Node node) {
            List list = this._getChildren(node);
            return list.size() > 0 ? (Node)list.get(0) : null;
        }

        private Node _getLastChild(Node node) {
            List list = this._getChildren(node);
            return list.size() > 0 ? (Node)list.get(list.size() - 1) : null;
        }

        private Node _getNextChild(Node node) {
            Node node2 = this._findParent(node);
            if (this.isFake(node2)) {
                List list = this._getChildren(node2);
                int n = list.indexOf(node);
                return n == list.size() - 1 ? null : (Node)list.get(n + 1);
            }
            return node.getNextSibling();
        }

        private Node _getPreviousChild(Node node) {
            Node node2 = this._findParent(node);
            if (this.isFake(node2)) {
                List list = this._getChildren(node2);
                int n = list.indexOf(node);
                return n == 0 ? null : (Node)list.get(n - 1);
            }
            return node.getPreviousSibling();
        }

        private List _getChildren(Node node) {
            List list = (List)this._fakeChildToFakeChildChildren.get(node);
            if (list == null) {
                Element element = node.getOwnerDocument().getDocumentElement();
                list = this._findChildren(element, DomUtils.getLocalName((Node)node));
                this._fakeChildToFakeChildChildren.put(node, list);
            }
            return list;
        }

        private List _findChildren(Element element, String string) {
            NodeList nodeList = element.getChildNodes();
            if (nodeList.getLength() == 0) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Node> arrayList = Collections.EMPTY_LIST;
            int n = 0;
            while (n < nodeList.getLength()) {
                String string2;
                Node node = nodeList.item(n);
                if (this._childIsCategorized.get(node) == null && string.equals(string2 = this._view.getCategory(node))) {
                    this._childIsCategorized.put(node, Boolean.TRUE);
                    if (arrayList == Collections.EMPTY_LIST) {
                        arrayList = new ArrayList<Node>();
                    }
                    arrayList.add(node);
                }
                ++n;
            }
            return arrayList;
        }

        void $init$() {
            this._childNameToIndex = new HashMap();
            this._childIsCategorized = new HashMap();
            this._childToFakeParent = new HashMap();
            this._fakeChildToFakeChildChildren = new HashMap();
        }

        static Node mav$_getLastChild(BeforeTraversal beforeTraversal, Node node) {
            return beforeTraversal._getLastChild(node);
        }

        static Node mav$_getFirstChild(BeforeTraversal beforeTraversal, Node node) {
            return beforeTraversal._getFirstChild(node);
        }

        static Node mav$_getPreviousFakeChild(BeforeTraversal beforeTraversal, Node node) {
            return beforeTraversal._getPreviousFakeChild(node);
        }

        static Node mav$_getNextFakeChild(BeforeTraversal beforeTraversal, Node node) {
            return beforeTraversal._getNextFakeChild(node);
        }
    }

    private class CategorizedMetadataResolver
    extends XmlMetadataResolver {
        public CategorizedMetadataResolver(MetadataEvaluator metadataEvaluator, XmlView xmlView) {
            super(metadataEvaluator, xmlView);
        }

        protected boolean isTransferableImpl(XmlKey xmlKey, Node node) {
            return this._isRootOrCategory(xmlKey, node) ? false : super.isTransferableImpl(xmlKey, node);
        }

        protected boolean isDeletableImpl(XmlKey xmlKey, Node node) {
            return this._isRootOrCategory(xmlKey, node) ? false : super.isDeletableImpl(xmlKey, node);
        }

        protected boolean isImmutableImpl(XmlKey xmlKey, Node node) {
            return CategorizedView.this.isCategoryNodeKey(xmlKey) ? true : super.isImmutableImpl(xmlKey, node);
        }

        public boolean isSurroundable(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length == 0) {
                return false;
            }
            int n = 0;
            while (n < nodeArray.length) {
                XmlKey xmlKey = this.getNodeXmlKey(nodeArray[n]);
                if (this._isRootOrCategory(xmlKey, nodeArray[n])) {
                    return false;
                }
                ++n;
            }
            return super.isSurroundable(nodeArray);
        }

        public boolean isConvertible(Node node) {
            if (node == null) {
                return false;
            }
            return this._isRootOrCategory(this.getNodeXmlKey(node), node) ? false : super.isConvertible(node);
        }

        private boolean _isRootOrCategory(XmlKey xmlKey, Node node) {
            return CategorizedView.this.isRootNode(xmlKey, node) || CategorizedView.this.isCategoryNodeKey(xmlKey);
        }
    }

    private class CategorizedMetadataEvaluator
    implements MetadataEvaluator {
        public Object getMetadataItem(Object object, Object object2, Node node) {
            XmlKey xmlKey = (XmlKey)object;
            if (CategorizedView.this.isCategoryNodeKey(xmlKey)) {
                return CategorizedView.this.getCategoryMetadataItem((QualifiedName)object2, xmlKey.getLocalName());
            }
            return CategorizedView.this.getBaseModel().getXmlMetadataResolver().getMetadataEvaluator().getMetadataItem(object, object2, node);
        }

        public Collection getPseudoXmlKeys(Object object) {
            return CategorizedView.this.getBaseModel().getXmlMetadataResolver().getMetadataEvaluator().getPseudoXmlKeys(object);
        }

        private CategorizedMetadataEvaluator() {
        }

        CategorizedMetadataEvaluator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

