/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bali.share.collection.OptimisticHashMap;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.FilteredTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.view.standalone.ProxyingElement;
import oracle.bali.xml.dom.view.standalone.ProxyingNode;
import oracle.bali.xml.dom.view.standalone.StandaloneElement;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.view.AbstractSlotsFolderView;
import oracle.bali.xml.share.ImmutableFilteredCollection;
import oracle.bali.xml.util.XmlKeyDisplayNameComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SlotsFolderViewTraversal
extends TreeTraversal
implements GrammarResolverListener {
    private static final String _BOGUS_NAMESPACE = "http://xmlns.oracle.com/bogus";
    private static final String _CHILD_SLOTS_LOCAL_NAME = "slots";
    private static final XmlKey _CHILD_SLOTS_KEY = ImmutableXmlKey.createElementKey((String)"http://xmlns.oracle.com/bogus", (String)"slots");
    private final HashMap _childSlotsNodes;
    private final HashMap _namedChildProxies;
    private final OptimisticHashMap _parentKeyToPotentialSlots;
    private final TreeTraversal _ignoreSlotsTraversal;
    private final AbstractSlotsFolderView _view;

    public SlotsFolderViewTraversal(AbstractSlotsFolderView abstractSlotsFolderView) {
        this.$init$();
        this._view = abstractSlotsFolderView;
    }

    public XmlKey getSlotsFolderKey() {
        return _CHILD_SLOTS_KEY;
    }

    public final boolean isSlotsFolderNode(Node node) {
        if (node == null) {
            return true;
        }
        return _BOGUS_NAMESPACE == node.getNamespaceURI();
    }

    public final boolean isSlotsFolderKey(Object object) {
        return _CHILD_SLOTS_KEY.equals(object);
    }

    public final boolean isNamedChildSlotProxy(Node node) {
        Node node2 = node.getParentNode();
        return node2 != null && this.isSlotsFolderNode(node2);
    }

    public final boolean isFakeNamedChildSlotProxy(Node node) {
        if (this.isNamedChildSlotProxy(node)) {
            return node instanceof ProxyingNode ^ true;
        }
        return false;
    }

    public Node getParentNode(Node node) {
        Node node2;
        Object v = this._namedChildProxies.get(node);
        if (v != null) {
            node = (Node)v;
        }
        if ((node2 = node.getParentNode()) == null) {
            return null;
        }
        if (this._view.isSlot(node2)) {
            this.getChildSlotsNode(node2.getParentNode());
            return (Node)this._namedChildProxies.get(node2);
        }
        return node2;
    }

    public Node getFirstChild(Node node) {
        if (this.isSlotsFolderNode(node)) {
            return node.getFirstChild();
        }
        Node node2 = this._ignoreSlotsTraversal.getFirstChild(node);
        if (node2 != null) {
            return node2;
        }
        if (this._view.isSlotParent(node)) {
            return this.getChildSlotsNode(node);
        }
        return null;
    }

    public Node getLastChild(Node node) {
        Node node2;
        if (this.isSlotsFolderNode(node)) {
            return node.getLastChild();
        }
        if (this._view.isSlotParent(node) && (node2 = this.getChildSlotsNode(node)) != null) {
            return node2;
        }
        return this._ignoreSlotsTraversal.getLastChild(node);
    }

    public Node getNextSibling(Node node) {
        if (!this.isSlotsFolderNode(node)) {
            Node node2;
            Node node3 = node.getParentNode();
            if (this.isSlotsFolderNode(node3)) {
                return node.getNextSibling();
            }
            Node node4 = this._ignoreSlotsTraversal.getNextSibling(node);
            if (node4 != null) {
                return node4;
            }
            if (this._view.isSlotParent(node3) && (node2 = this.getChildSlotsNode(node3)) != null) {
                return node2;
            }
        }
        return null;
    }

    public Node getPreviousSibling(Node node) {
        Node node2 = node.getParentNode();
        if (this.isSlotsFolderNode(node)) {
            return this._ignoreSlotsTraversal.getLastChild(node2);
        }
        if (this.isSlotsFolderNode(node2)) {
            return node.getPreviousSibling();
        }
        return this._ignoreSlotsTraversal.getPreviousSibling(node);
    }

    public void updateCache(Node node) {
        Document document = this._view.getDocument();
        if (document == null) {
            return;
        }
        if (node == document || node == document.getDocumentElement()) {
            for (Map.Entry entry : this._childSlotsNodes.entrySet()) {
                StandaloneElement standaloneElement = (StandaloneElement)entry.getValue();
                if (standaloneElement == null) continue;
                standaloneElement.setParentNode(null);
            }
            this._childSlotsNodes.clear();
            this._namedChildProxies.clear();
            return;
        }
        LinkedList<Node> linkedList = null;
        for (Node node2 : this._childSlotsNodes.keySet()) {
            if (!DomUtils.isNodeOrDescendant((Node)node2, (Node)node)) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<Node>();
            }
            linkedList.add(node2);
        }
        if (linkedList != null) {
            HashMap hashMap = this._namedChildProxies;
            HashMap hashMap2 = this._childSlotsNodes;
            for (Object e : linkedList) {
                Object v = hashMap2.remove(e);
                if (v == null) continue;
                StandaloneElement standaloneElement = (StandaloneElement)v;
                Node node3 = standaloneElement.getFirstChild();
                do {
                    if (!(node3 instanceof ProxyingNode)) continue;
                    Node node4 = ((ProxyingNode)((Object)node3)).getProxiedNode();
                    hashMap.remove(node4);
                } while ((node3 = node3.getNextSibling()) != null);
                standaloneElement.setParentNode(null);
            }
        }
    }

    public Node getChildSlotsNode(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = (Node)this._childSlotsNodes.get(node);
        if (node2 == null) {
            node2 = null;
            List list = this._getPotentialSlotKeys(node);
            if (!list.isEmpty()) {
                node2 = this._createFakeChildrenNode(node, list);
            }
            this._childSlotsNodes.put(node, node2);
        }
        return node2;
    }

    public void grammarResolverChanged(GrammarResolverEvent grammarResolverEvent) {
        this._parentKeyToPotentialSlots.clear();
    }

    Node __getNamedChildSlotProxy(Node node) {
        Node node2;
        Node node3;
        if (node == null) {
            return null;
        }
        Node node4 = (Node)this._namedChildProxies.get(node);
        if (node4 == null && (node3 = this.getChildSlotsNode(node2 = node.getParentNode())) != null) {
            node4 = (Node)this._namedChildProxies.get(node);
        }
        return node4;
    }

    private List _getPotentialSlotKeys(Node node) {
        XmlKey xmlKey = this._view.getNodeXmlKey(node);
        if (!this._view.isSlotParent(xmlKey)) {
            return Collections.EMPTY_LIST;
        }
        List list = (List)this._parentKeyToPotentialSlots.get((Object)xmlKey);
        if (list != null) {
            return list;
        }
        List list2 = this._createPotentialSlotKeys(xmlKey);
        this._parentKeyToPotentialSlots.put((Object)xmlKey, (Object)list2);
        return list2;
    }

    private List _createPotentialSlotKeys(XmlKey xmlKey) {
        XmlMetadataResolver xmlMetadataResolver = this._view.getXmlMetadataResolver();
        Collection collection = xmlMetadataResolver.getCreateableChildrenXmlKeys(null, xmlKey);
        Iterator iterator = ImmutableFilteredCollection.createFilterIterator(collection, new 1());
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        if (linkedList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList(linkedList);
        Collections.sort(arrayList, new XmlKeyDisplayNameComparator(xmlMetadataResolver));
        return arrayList;
    }

    private Node _createFakeChildrenNode(Node node, List list) {
        XmlMetadataResolver xmlMetadataResolver = this._view.getXmlMetadataResolver();
        Document document = this._view.getDocument();
        StandaloneElement standaloneElement = new StandaloneElement(document, _BOGUS_NAMESPACE, null, _CHILD_SLOTS_LOCAL_NAME);
        standaloneElement.setParentNode(node);
        Map map = this._getSlotNodes(node);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            XmlKey xmlKey = (XmlKey)list.get(n2);
            Node node2 = (Node)map.get(xmlKey);
            StandaloneElement standaloneElement2 = null;
            if (node2 != null) {
                ProxyingElement proxyingElement = new ProxyingElement((Element)node2, false);
                this._namedChildProxies.put(node2, proxyingElement);
                standaloneElement2 = proxyingElement;
            } else if (!xmlMetadataResolver.isDeprecated(xmlKey)) {
                QualifiedName qualifiedName = xmlKey.getElementQName();
                standaloneElement2 = new StandaloneElement(document, qualifiedName.getNamespace(), null, qualifiedName.getName());
                if (qualifiedName.getAttributeName() != null) {
                    ((Element)standaloneElement2).setAttributeNS(qualifiedName.getAttributeNamespace(), qualifiedName.getAttributeName(), qualifiedName.getAttributeValue());
                }
            }
            if (standaloneElement2 != null) {
                standaloneElement.appendChild(standaloneElement2);
            }
            ++n2;
        }
        return standaloneElement;
    }

    private Map _getSlotNodes(Node node) {
        DocumentTreeTraversal documentTreeTraversal = DocumentTreeTraversal.INSTANCE;
        Node node2 = null;
        HashMap<XmlKey, Node> hashMap = null;
        Node node3 = documentTreeTraversal.getFirstChild(node);
        while (node3 != null) {
            if (this._view.isSlot(node3)) {
                if (hashMap == null) {
                    if (node2 == null) {
                        node2 = node3;
                    } else {
                        hashMap = new HashMap<XmlKey, Node>(documentTreeTraversal.getChildCount(node));
                        hashMap.put(this._view.getNodeXmlKey(node2), node2);
                        hashMap.put(this._view.getNodeXmlKey(node3), node3);
                    }
                } else {
                    hashMap.put(this._view.getNodeXmlKey(node3), node3);
                }
            }
            node3 = documentTreeTraversal.getNextSibling(node3);
        }
        if (hashMap == null) {
            if (node2 != null) {
                return Collections.singletonMap(this._view.getNodeXmlKey(node2), node2);
            }
            return Collections.EMPTY_MAP;
        }
        return hashMap;
    }

    void $init$() {
        this._childSlotsNodes = new HashMap();
        this._namedChildProxies = new HashMap();
        this._parentKeyToPotentialSlots = new OptimisticHashMap();
        this._ignoreSlotsTraversal = new IgnoreSlotsTraversal(null);
    }

    static AbstractSlotsFolderView ra$_view(SlotsFolderViewTraversal slotsFolderViewTraversal) {
        return slotsFolderViewTraversal._view;
    }

    final class 1
    implements ImmutableFilteredCollection.Filter {
        public boolean accept(Object object) {
            XmlKey xmlKey = (XmlKey)object;
            return SlotsFolderViewTraversal.ra$_view(SlotsFolderViewTraversal.this).isSlot(xmlKey);
        }
    }

    private class IgnoreSlotsTraversal
    extends FilteredTreeTraversal {
        protected short acceptNode(Node node) {
            if (SlotsFolderViewTraversal.ra$_view(SlotsFolderViewTraversal.this).isSlot(node)) {
                return 2;
            }
            return 1;
        }

        private IgnoreSlotsTraversal() {
        }

        IgnoreSlotsTraversal(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

