/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.share.ReverseListIterator;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.logging.LogUtils;

public abstract class AbstractTransactionMediator {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Map _tokenToInfo;
    private static final Logger _LOGGER;

    public final TransactionToken createToken() {
        return new TransactionTokenImpl(null);
    }

    static {
        $assertionsDisabled = AbstractTransactionMediator.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger(AbstractTransactionMediator.class.getName());
    }

    public final void commitTransaction(TransactionToken transactionToken) {
        Info info = this._getAndRemoveInfo(transactionToken);
        this._txnLog("commit", transactionToken, info);
        if (info == null) {
            return;
        }
        if (info.edits.size() == 1) {
            if (!$assertionsDisabled && info.documents.size() != 1) {
                throw new AssertionError();
            }
            this._deliverOneEdit(info.documents.iterator().next(), (UndoableEdit)info.edits.get(0));
        } else {
            this._deliverMultipleEdits(transactionToken, info);
        }
    }

    public final void rollbackTransaction(TransactionToken transactionToken) {
        Info info = this._getAndRemoveInfo(transactionToken);
        this._txnLog("rollback", transactionToken, info);
        if (info == null) {
            return;
        }
        Iterator iterator = ReverseListIterator.getIterator(info.edits, false);
        while (iterator.hasNext()) {
            UndoableEdit undoableEdit = (UndoableEdit)iterator.next();
            try {
                if (_LOGGER.isLoggable(Level.FINE)) {
                    _LOGGER.log(Level.FINE, "Undo of edit {0} during rollback of transaction {1}", new Object[]{undoableEdit, transactionToken});
                }
                undoableEdit.undo();
            }
            catch (Throwable throwable) {
                LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Exception executing undo of edit {0} during rollback of transaction {1}", (Object[])new Object[]{undoableEdit, transactionToken}, (Throwable)throwable);
                if (!(throwable instanceof ThreadDeath)) continue;
                throw (ThreadDeath)throwable;
            }
        }
    }

    protected void addEditImpl(TransactionToken transactionToken, Object object, UndoableEdit undoableEdit) {
        if (transactionToken == null) {
            this._deliverOneEdit(object, undoableEdit);
        } else {
            if (((TransactionTokenImpl)transactionToken).__isDispatched()) {
                throw new IllegalStateException("token already used! " + transactionToken);
            }
            this._bufferOneEdit(transactionToken, object, undoableEdit);
        }
    }

    protected abstract void deliverMultipleEditsImpl(TransactionToken var1, Info var2);

    protected abstract void deliverOneEditImpl(Object var1, UndoableEdit var2);

    private void _txnLog(String string, TransactionToken transactionToken, Info info) {
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "About to {0}: token={1} numEdits={2}", new Object[]{string, transactionToken, info == null ? "0" : String.valueOf(info.edits.size())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info _getAndRemoveInfo(TransactionToken transactionToken) {
        if (transactionToken == null) {
            return null;
        }
        ((TransactionTokenImpl)transactionToken).__setDispatched();
        Map map = this._tokenToInfo;
        synchronized (map) {
            Info info = (Info)this._tokenToInfo.remove(transactionToken);
            if (!$assertionsDisabled && info != null && info.edits.size() <= 0) {
                throw new AssertionError();
            }
            Info info2 = info;
            return info2;
        }
    }

    private void _deliverMultipleEdits(TransactionToken transactionToken, Info info) {
        _LOGGER.log(Level.FINE, "Dispatching multiple edits: token={0}", transactionToken);
        this.deliverMultipleEditsImpl(transactionToken, info);
    }

    private void _deliverOneEdit(Object object, UndoableEdit undoableEdit) {
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "Dispatching single edit: doc={0} edit={1}", new Object[]{object, undoableEdit});
        }
        this.deliverOneEditImpl(object, undoableEdit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _bufferOneEdit(TransactionToken transactionToken, Object object, UndoableEdit undoableEdit) {
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "Buffering edit: token={0} doc={1} edit={2}", new Object[]{transactionToken, object, undoableEdit});
        }
        if (!$assertionsDisabled && transactionToken == null) {
            throw new AssertionError();
        }
        Map map = this._tokenToInfo;
        synchronized (map) {
            Info info = (Info)this._tokenToInfo.get(transactionToken);
            if (info == null) {
                info = new Info();
                this._tokenToInfo.put(transactionToken, info);
            }
            info.add(object, undoableEdit);
        }
    }

    void $init$() {
        this._tokenToInfo = new HashMap();
    }

    public AbstractTransactionMediator() {
        this.$init$();
    }

    private class TransactionTokenImpl
    extends TransactionToken {
        private String _name;
        private WeakReference _ownerRef;
        private boolean _dispatched;

        public synchronized Object getOwner() {
            if (this._ownerRef == null) {
                return null;
            }
            return this._ownerRef.get();
        }

        public synchronized String getName() {
            return this._name;
        }

        public synchronized void setNameIfUnset(String string) {
            if (this._name == null) {
                this._name = string;
            }
        }

        public synchronized void setOwnerIfUnset(Object object) {
            if (this._ownerRef == null) {
                this._ownerRef = new WeakReference<Object>(object);
            }
        }

        public synchronized void dispatch(Object object, boolean bl) {
            if (object == this.getOwner()) {
                if (bl) {
                    AbstractTransactionMediator.this.commitTransaction(this);
                } else {
                    AbstractTransactionMediator.this.rollbackTransaction(this);
                }
            }
        }

        synchronized boolean __isDispatched() {
            return this._dispatched;
        }

        synchronized void __setDispatched() {
            this._dispatched = true;
        }

        void $init$() {
            this._dispatched = false;
        }

        private TransactionTokenImpl() {
            this.$init$();
        }

        TransactionTokenImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    protected static class Info {
        public final Set documents;
        public final List edits;

        public void add(Object object, UndoableEdit undoableEdit) {
            this.documents.add(object);
            this.edits.add(undoableEdit);
        }

        void $init$() {
            this.documents = new HashSet(7);
            this.edits = new ArrayList(10);
        }

        protected Info() {
            this.$init$();
        }
    }
}

