/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.share.ReverseListIterator;

public class MultiUndoableEdit
implements UndoableEdit {
    private final UndoableEdit _first;
    private final List _edits;

    public static UndoableEdit createEdit(List list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (UndoableEdit)list.get(0);
        }
        return new MultiUndoableEdit(new ArrayList(list));
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this._do(true);
    }

    public boolean canUndo() {
        return this._can(true);
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotUndoException();
        }
        this._do(false);
    }

    public boolean canRedo() {
        return this._can(false);
    }

    public void die() {
        for (UndoableEdit undoableEdit : this._edits) {
            undoableEdit.die();
        }
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public boolean isSignificant() {
        for (UndoableEdit undoableEdit : this._edits) {
            if (!undoableEdit.isSignificant()) continue;
            return true;
        }
        return false;
    }

    public String getPresentationName() {
        return this._first.getPresentationName();
    }

    public String getUndoPresentationName() {
        return this._first.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        return this._first.getRedoPresentationName();
    }

    public String toString() {
        return super.toString() + " edits: " + this._edits;
    }

    private boolean _can(boolean bl) {
        for (UndoableEdit undoableEdit : this._edits) {
            boolean bl2;
            boolean bl3 = bl2 = bl ? undoableEdit.canUndo() : undoableEdit.canRedo();
            if (bl2) continue;
            return false;
        }
        return true;
    }

    private void _do(boolean bl) {
        Iterator iterator = ReverseListIterator.getIterator(this._edits, bl ^ true);
        while (iterator.hasNext()) {
            UndoableEdit undoableEdit = (UndoableEdit)iterator.next();
            if (bl) {
                undoableEdit.undo();
                continue;
            }
            undoableEdit.redo();
        }
    }

    private MultiUndoableEdit(List list) {
        this._edits = list;
        this._first = (UndoableEdit)list.get(0);
    }
}

