/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

public final class PropertyChange {
    private String _propertyName;
    private Object _oldValue;
    private Object _newValue;
    private transient int _hashCode;

    public PropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public PropertyChange(String string, Object object, Object object2) {
        if (string == null) {
            throw new IllegalArgumentException("Property name required");
        }
        this._propertyName = string;
        this._oldValue = object;
        this._newValue = object2;
        int n = string.hashCode();
        if (object != null) {
            n ^= object.hashCode() * 7;
        }
        if (object2 != null) {
            n ^= object2.hashCode() * 49;
        }
        this._hashCode = n;
    }

    public static PropertyChange getPropertyChange(String string, Object object, Object object2) {
        if (!(object == object2 || object != null && object.equals(object2))) {
            return new PropertyChange(string, object, object2);
        }
        return null;
    }

    public static PropertyChange mergePropertyChange(PropertyChange propertyChange, PropertyChange propertyChange2) {
        if (propertyChange2 == null) {
            return propertyChange;
        }
        if (propertyChange == null) {
            return propertyChange2;
        }
        String string = propertyChange.getPropertyName();
        if (!string.equals(propertyChange2.getPropertyName())) {
            throw new IllegalArgumentException(propertyChange + " and " + propertyChange2 + " have different property names");
        }
        Object object = propertyChange.getNewValue();
        Object object2 = propertyChange2.getNewValue();
        Object object3 = propertyChange.getOldValue();
        if (PropertyChange._eq(object, object2)) {
            return propertyChange;
        }
        if (PropertyChange._eq(object3, object2)) {
            return null;
        }
        return PropertyChange.getPropertyChange(string, propertyChange.getOldValue(), object2);
    }

    public final PropertyChange mergePropertyChange(PropertyChange propertyChange) {
        return PropertyChange.mergePropertyChange(this, propertyChange);
    }

    public static Map mergePropertyChangeToMap(Map map, PropertyChange propertyChange) {
        return PropertyChange._mergePropertyChangeToMap(map, propertyChange, true);
    }

    public static Map mergePropertyChangeMaps(Map map, Map map2, Map hashMap) {
        if (map2 == null || map2.isEmpty()) {
            return map;
        }
        if (map == null || map.isEmpty()) {
            return map2;
        }
        Map map3 = hashMap;
        if (map3 == null) {
            map3 = new HashMap(map);
        } else if (map3 != map) {
            map3.clear();
            map3.putAll(map);
        }
        for (Map.Entry entry : map2.entrySet()) {
            PropertyChange propertyChange = (PropertyChange)entry.getValue();
            map3 = PropertyChange._mergePropertyChangeToMap(map3, propertyChange, false);
        }
        return map3;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Object getOldValue() {
        return this._oldValue;
    }

    public Object getNewValue() {
        return this._newValue;
    }

    public final boolean getOldBooleanValue() {
        return Boolean.TRUE.equals(this.getOldValue());
    }

    public final boolean getNewBooleanValue() {
        return Boolean.TRUE.equals(this.getNewValue());
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != PropertyChange.class || object.hashCode() != this.hashCode()) {
            return false;
        }
        PropertyChange propertyChange = (PropertyChange)object;
        return PropertyChange._eq(propertyChange.getPropertyName(), this.getPropertyName()) && PropertyChange._eq(propertyChange.getOldValue(), this.getOldValue()) && PropertyChange._eq(propertyChange.getNewValue(), this.getNewValue());
    }

    public String toString() {
        return this._propertyName + ": " + this._oldValue + " --> " + this._newValue;
    }

    private static boolean _eq(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private static Map _mergePropertyChangeToMap(Map hashMap, PropertyChange propertyChange, boolean bl) {
        PropertyChange propertyChange2;
        String string = propertyChange.getPropertyName();
        PropertyChange propertyChange3 = (PropertyChange)hashMap.get(string);
        if (propertyChange3 != (propertyChange2 = PropertyChange.mergePropertyChange(propertyChange3, propertyChange))) {
            if (bl && !(hashMap instanceof HashMap)) {
                hashMap = new HashMap<String, PropertyChange>(hashMap);
            }
            if (propertyChange2 == null) {
                hashMap.remove(string);
            } else {
                hashMap.put(string, propertyChange2);
            }
        }
        return hashMap;
    }
}

