/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.util.EventListener;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.share.UnmodifiableArrayIterator;

public class SafeListenerManager {
    private Object[] _array;
    private static final Logger _LOGGER = Logger.getLogger(SafeListenerManager.class.getName());

    public synchronized void addListener(Object object) {
        if (this._find(object) != -1) {
            this._logError("Tried to add listener to the same listener manager twice! Manager={0} Listener={1}", object);
            return;
        }
        Object[] objectArray = new Object[this._array.length + 1];
        System.arraycopy(this._array, 0, objectArray, 0, this._array.length);
        objectArray[objectArray.length - 1] = object;
        this._array = objectArray;
    }

    public synchronized void removeListener(Object object) {
        this.removeListener(object, true);
    }

    public synchronized void removeListener(Object object, boolean bl) {
        int n;
        int n2 = this._find(object);
        if (n2 == -1) {
            if (bl) {
                this._logError("Tried to remove a listener from a listener manager where it was not registered! Manager={0} Listener={1}", object);
            }
            return;
        }
        Object[] objectArray = new Object[this._array.length - 1];
        int n3 = n2;
        if (n3 > 0) {
            System.arraycopy(this._array, 0, objectArray, 0, n3);
        }
        if ((n = objectArray.length - n2) > 0) {
            System.arraycopy(this._array, n2 + 1, objectArray, n2, n);
        }
        this._array = objectArray;
    }

    public synchronized Iterator iterator() {
        return new UnmodifiableArrayIterator(this._array);
    }

    public synchronized boolean isEmpty() {
        return this._array.length == 0;
    }

    public Iterator iteratorOnSameContents(Iterator iterator) {
        if (!(iterator instanceof UnmodifiableArrayIterator)) {
            throw new IllegalArgumentException("parameter must be an iterator returned from this class!");
        }
        return new UnmodifiableArrayIterator((UnmodifiableArrayIterator)iterator);
    }

    private int _find(Object object) {
        int n = 0;
        while (n < this._array.length) {
            if (this._array[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void _logError(String string, Object object) {
        if (_LOGGER.isLoggable(Level.SEVERE)) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, string);
            logRecord.setParameters(new Object[]{this, object});
            logRecord.setThrown(new RuntimeException("stack trace"));
            _LOGGER.log(logRecord);
        }
    }

    void $init$() {
        this._array = new EventListener[0];
    }

    public SafeListenerManager() {
        this.$init$();
    }
}

