/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.share.util.BooleanUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.share.SafeListenerManager;

public class SafePropertyChangeSupport {
    private final Object _sourceBean;
    private final SafeListenerManager _manager;

    public SafePropertyChangeSupport(Object object) {
        this.$init$();
        if (object == null) {
            throw new NullPointerException("Source bean can not be null!");
        }
        this._sourceBean = object;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._manager.addListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._manager.removeListener(propertyChangeListener);
    }

    public boolean hasListeners() {
        return this._manager.isEmpty() ^ true;
    }

    public void firePropertyChanges(Collection collection) {
        Iterator iterator = this._manager.iterator();
        while (iterator.hasNext()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator.next();
            for (Object e : collection) {
                if (!(e instanceof PropertyChangeEvent)) continue;
                try {
                    propertyChangeListener.propertyChange((PropertyChangeEvent)e);
                }
                catch (RuntimeException runtimeException) {
                    Logger.getLogger(this._sourceBean.getClass().getName()).log(Level.WARNING, "Uncaught exception during event dispatching: event=" + e + " listener=" + propertyChangeListener, runtimeException);
                }
            }
        }
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() != null) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object != null && object.equals(object2)) {
                return;
            }
        }
        Iterator iterator = this._manager.iterator();
        while (iterator.hasNext()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator.next();
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(new PropertyChangeEvent(this._sourceBean, string, object, object2));
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, BooleanUtils.getBoolean((boolean)bl), BooleanUtils.getBoolean((boolean)bl2));
    }

    public void firePropertyChange(String string, int n, int n2) {
        this.firePropertyChange(string, IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)n2));
    }

    void $init$() {
        this._manager = new SafeListenerManager();
    }
}

