/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.clipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.xml.share.clipboard.NullTransferable;
import oracle.javatools.logging.LogUtils;

public abstract class ClipboardManager {
    public static final Transferable EMPTY_CONTENTS = new NullTransferable("empty");
    public static final Transferable UNKNOWN_CONTENTS = new NullTransferable("unknown");
    private boolean _isAppActive;
    private final Set _listenerRefs;
    private final ReferenceQueue _queue;
    private static final Logger _sLOGGER = Logger.getLogger(ClipboardManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFlavorListener(ChangeListener changeListener) {
        boolean bl = this.areFlavorListenersAttached() ^ true;
        Set set = this._listenerRefs;
        synchronized (set) {
            Iterator iterator = this._findListener(changeListener);
            if (iterator != null) {
                this.getLogger().log(Level.SEVERE, "Tried to add listener that was already attached: {0}", changeListener);
            } else {
                WeakReference<ChangeListener> weakReference = new WeakReference<ChangeListener>(changeListener, this._queue);
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "Adding listener {0} via ref {1}", new Object[]{changeListener, weakReference});
                }
                this._listenerRefs.add(weakReference);
            }
        }
        if (bl) {
            this.areFlavorListenersAttachedChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFlavorListener(ChangeListener changeListener) {
        Set set = this._listenerRefs;
        synchronized (set) {
            Iterator iterator = this._findListener(changeListener);
            if (iterator == null) {
                this.getLogger().log(Level.SEVERE, "Tried to remove listener that was not attached: {0}", changeListener);
            } else {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "Removing listener {0}; refs set before={1}", new Object[]{changeListener, this._listenerRefs});
                }
                iterator.remove();
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "Removed listener {0}; refs set after={1}", new Object[]{changeListener, this._listenerRefs});
                }
            }
            this._removeDeadListenerReferences();
        }
        if (!this.areFlavorListenersAttached()) {
            this.areFlavorListenersAttachedChanged();
        }
    }

    public abstract Transferable getContents();

    public abstract void setContents(Transferable var1) throws IllegalStateException;

    public DataFlavor[] getAvailableDataFlavors() {
        return ClipboardManager.fixNullFlavorArray(this.getContents().getTransferDataFlavors());
    }

    public boolean isDataFlavorAvailable(DataFlavor dataFlavor) {
        return this.getContents().isDataFlavorSupported(dataFlavor);
    }

    public Object getData(DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        return this.getContents().getTransferData(dataFlavor);
    }

    public void setApplicationActive(boolean bl) {
        boolean bl2 = bl != this._isAppActive;
        this._isAppActive = bl;
        if (bl2) {
            this.applicationActiveChanged();
        }
    }

    public boolean isApplicationActive() {
        return this._isAppActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean areFlavorListenersAttached() {
        Set set = this._listenerRefs;
        synchronized (set) {
            boolean bl = this._listenerRefs.isEmpty() ^ true;
            return bl;
        }
    }

    protected void areFlavorListenersAttachedChanged() {
    }

    protected void applicationActiveChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFlavorListeners() {
        if (this.areFlavorListenersAttached()) {
            Reference[] referenceArray;
            _sLOGGER.fine("notifying flavor listeners!");
            Set set = this._listenerRefs;
            synchronized (set) {
                this._removeDeadListenerReferences();
                if (!this.areFlavorListenersAttached()) {
                    this.areFlavorListenersAttachedChanged();
                    referenceArray = null;
                } else {
                    referenceArray = this._listenerRefs.toArray(new Reference[this._listenerRefs.size()]);
                }
            }
            if (referenceArray != null && referenceArray.length > 0) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                int n = 0;
                while (n < referenceArray.length) {
                    ChangeListener changeListener = (ChangeListener)referenceArray[n].get();
                    if (changeListener != null) {
                        try {
                            changeListener.stateChanged(changeEvent);
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable) {
                            LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Unexpected exception notifying flavor listener {0}", (Object)changeListener, (Throwable)throwable);
                        }
                    }
                    ++n;
                }
            }
        }
    }

    protected final Logger getLogger() {
        return _sLOGGER;
    }

    protected static final boolean areDifferent(DataFlavor[] dataFlavorArray, DataFlavor[] dataFlavorArray2) {
        return Arrays.equals(dataFlavorArray, dataFlavorArray2) ^ true;
    }

    protected static DataFlavor[] fixNullFlavorArray(DataFlavor[] dataFlavorArray) {
        if (dataFlavorArray == null) {
            return EMPTY_CONTENTS.getTransferDataFlavors();
        }
        return dataFlavorArray;
    }

    private void _removeDeadListenerReferences() {
        Reference reference;
        int n = 0;
        while ((reference = this._queue.poll()) != null) {
            boolean bl = this._listenerRefs.remove(reference);
            if (!bl) {
                this.getLogger().log(Level.SEVERE, "Dead reference not found in the set! {0}", reference);
            }
            ++n;
        }
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().log(Level.FINE, "Cleaned up {0} dead listener references; attached={1}", new Object[]{new Integer(n), this._listenerRefs});
        }
    }

    private Iterator _findListener(ChangeListener changeListener) {
        Iterator iterator = this._listenerRefs.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (changeListener != reference.get()) continue;
            return iterator;
        }
        return null;
    }

    void $init$() {
        this._isAppActive = true;
        this._listenerRefs = new LinkedHashSet();
        this._queue = new ReferenceQueue();
    }

    public ClipboardManager() {
        this.$init$();
    }
}

