/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.share.clipboard.AWTClipboardManager;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;

class Jdk15AWTClipboardManager
extends AWTClipboardManager
implements FlavorListener {
    private boolean _inSetContents;
    private boolean _listenerAttached;
    private Reference<Transferable> _cachedRef;
    private static final Clipboard _clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private static final Logger _LOGGER = Logger.getLogger(Jdk15AWTClipboardManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getContents() {
        DataFlavor dataFlavor = ExtendedTransferable.FLAVOR_EXTENDED_TRANSFERABLE;
        if (_clipboard.isDataFlavorAvailable(dataFlavor)) {
            try {
                Transferable transferable = (Transferable)_clipboard.getData(dataFlavor);
                return transferable;
            }
            catch (Exception exception) {
                _LOGGER.warning("ExtendedTransferable flavor was available but getData failed; falling back to regular path.");
            }
        }
        Jdk15AWTClipboardManager jdk15AWTClipboardManager = this;
        synchronized (jdk15AWTClipboardManager) {
            Transferable transferable;
            if (this._cachedRef != null && (transferable = this._cachedRef.get()) != null) {
                Transferable transferable2 = transferable;
                return transferable2;
            }
        }
        Transferable transferable = this._getContentsImpl();
        Jdk15AWTClipboardManager jdk15AWTClipboardManager2 = this;
        synchronized (jdk15AWTClipboardManager2) {
            this._cachedRef = new SoftReference<Transferable>(transferable);
        }
        return transferable;
    }

    public synchronized void setContents(Transferable transferable) {
        _LOGGER.log(Level.FINE, "setContents to {0}", transferable);
        this._cachedRef = new SoftReference<Transferable>(transferable);
        this._inSetContents = true;
        try {
            _clipboard.setContents(transferable, null);
        }
        finally {
            this._inSetContents = false;
        }
        this.notifyFlavorListeners();
    }

    public void flavorsChanged(FlavorEvent flavorEvent) {
        if (!this._inSetContents) {
            this._cachedRef = null;
            this.notifyFlavorListeners();
        }
    }

    Jdk15AWTClipboardManager() {
        this.$init$();
    }

    protected void areFlavorListenersAttachedChanged() {
        super.areFlavorListenersAttachedChanged();
        this._attachOrDetachIfNeeded();
    }

    protected void applicationActiveChanged() {
        super.applicationActiveChanged();
        boolean bl = this._attachOrDetachIfNeeded();
        if (bl) {
            this.notifyFlavorListeners();
        }
    }

    private synchronized boolean _attachOrDetachIfNeeded() {
        boolean bl;
        boolean bl2 = bl = this.isApplicationActive() && this.areFlavorListenersAttached();
        if (bl != this._listenerAttached) {
            if (_LOGGER.isLoggable(Level.FINE)) {
                _LOGGER.log(Level.FINE, "Clipboard manager attach/detach occuring; attaching={0}", bl);
            }
            if (bl) {
                _clipboard.addFlavorListener(this);
            } else {
                _clipboard.removeFlavorListener(this);
            }
            this._listenerAttached = bl;
            return this._listenerAttached;
        }
        return false;
    }

    private Transferable _getContentsImpl() {
        DataFlavor[] dataFlavorArray = _clipboard.getAvailableDataFlavors();
        if (dataFlavorArray == null || dataFlavorArray.length == 0) {
            _LOGGER.finer("getContents found no flavors");
            return ClipboardManager.EMPTY_CONTENTS;
        }
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "getContents found data; flavors={0}", Arrays.asList(dataFlavorArray));
        }
        return new LazyClipboardTransferable(dataFlavorArray);
    }

    void $init$() {
        this._inSetContents = false;
        this._listenerAttached = false;
    }

    static Clipboard ra$_clipboard() {
        return _clipboard;
    }

    private static class LazyClipboardTransferable
    extends ExtendedTransferable {
        private final Map<DataFlavor, List<TransferDataInfo>> _flavorToData;
        private final String _desc;

        public LazyClipboardTransferable(DataFlavor[] dataFlavorArray) {
            this._desc = TransferUtils.inventDescription((DataFlavor)dataFlavorArray[0]);
            Map<DataFlavor, List<LazyClipboardTDI>> map = new LinkedHashMap(dataFlavorArray.length);
            float f = 1.0f;
            DataFlavor[] dataFlavorArray2 = dataFlavorArray;
            int n = 0;
            while (n < dataFlavorArray2.length) {
                DataFlavor dataFlavor = dataFlavorArray2[n];
                LazyClipboardTDI lazyClipboardTDI = new LazyClipboardTDI(dataFlavor, f);
                map.put(dataFlavor, Collections.singletonList(lazyClipboardTDI));
                f = TransferUtils.lowerRank((float)f);
                ++n;
            }
            map = Collections.unmodifiableMap(map);
            this._flavorToData = map;
        }

        public List getDataInfos(DataFlavor dataFlavor) {
            List<TransferDataInfo> list = this._flavorToData.get(dataFlavor);
            if (list != null) {
                return list;
            }
            return Collections.EMPTY_LIST;
        }

        public Iterator getOrderedFlavorIterator() {
            return this._flavorToData.keySet().iterator();
        }

        public String getShortDescription() {
            return this._desc;
        }

        public String getMediumDescription() {
            return this.getShortDescription();
        }

        protected int getFlavorCount() {
            return this._flavorToData.size();
        }

        protected boolean isFlavorSupported(DataFlavor dataFlavor) {
            return this._flavorToData.containsKey(dataFlavor);
        }
    }

    private static class LazyClipboardTDI
    extends TransferDataInfo {
        private final DataFlavor _flavor;
        private final float _rank;

        public LazyClipboardTDI(DataFlavor dataFlavor, float f) {
            this._flavor = dataFlavor;
            this._rank = f;
        }

        public DataFlavor getDataFlavor() {
            return this._flavor;
        }

        public synchronized Object getData(FetchMode fetchMode, boolean bl) {
            if (fetchMode == FetchMode.STANDARD) {
                try {
                    Object object = Jdk15AWTClipboardManager.ra$_clipboard().getData(this._flavor);
                    return object;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public float getSuitabilityRank() {
            return this._rank;
        }
    }
}

