/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import oracle.bali.xml.share.clipboard.AWTClipboardManager;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.javatools.datatransfer.ExtendedTransferable;

class PollingClipboardManager
extends AWTClipboardManager {
    static final /* synthetic */ boolean $assertionsDisabled;
    private int _state;
    private boolean _ownsClipboard;
    private Reference _cachedContentsRef;
    private final Clipboard _clipboard;
    private final ClipboardOwner _owner;
    private static final int _INITIAL_STATE = 0;
    private static final int _POLLING_STATE = 1;
    private static final int _DISABLED_STATE = 2;
    private static final long _MIN_MS_BETWEEN_CLIPBOARD_POLLS = 1000L;
    private static final long _FAST_POLL_THRESHOLD = 100L;

    public synchronized Transferable getContents() {
        Transferable transferable = this._cached();
        if (transferable == null) {
            long l = System.currentTimeMillis();
            transferable = this._getContentsDirectly();
            long l2 = System.currentTimeMillis();
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, "Foreground clipboard poll in {0} ms", new Long(l2 - l));
            }
            this._updateCachedContents(transferable);
        }
        return transferable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Transferable transferable) throws IllegalStateException {
        this._clipboard.setContents(transferable, this._owner);
        this.getLogger().log(Level.FINE, "Set clipboard contents to {0}", transferable);
        PollingClipboardManager pollingClipboardManager = this;
        synchronized (pollingClipboardManager) {
            this._setClipboardOwnership(true);
            this._updateCachedContents(transferable);
        }
    }

    protected synchronized void areFlavorListenersAttachedChanged() {
        super.areFlavorListenersAttachedChanged();
        this._potentiallySwitchState();
    }

    protected synchronized void applicationActiveChanged() {
        super.applicationActiveChanged();
        this._potentiallySwitchState();
    }

    PollingClipboardManager() {
        this.$init$();
    }

    private synchronized boolean _shouldBePolling() {
        return !this._ownsClipboard && this.isApplicationActive() && this.areFlavorListenersAttached();
    }

    private synchronized void _potentiallySwitchState() {
        boolean bl = this._shouldBePolling();
        if (bl) {
            if (this._state == 0) {
                this._transitionInitialToPolling();
            } else if (this._state == 2) {
                this._transitionDisabledToPolling();
            }
        } else if (this._state == 1) {
            this._transitionPollingToDisabled();
        }
    }

    private synchronized void _setClipboardOwnership(boolean bl) {
        if (bl != this._ownsClipboard) {
            this._ownsClipboard = bl;
            this._potentiallySwitchState();
        }
    }

    static {
        $assertionsDisabled = PollingClipboardManager.class.desiredAssertionStatus() ^ true;
    }

    private synchronized void _transitionInitialToPolling() {
        if (!$assertionsDisabled && this._state != 0) {
            throw new AssertionError();
        }
        this._state = 1;
        this.getLogger().fine("Transitioning from initial to polling");
        Thread thread = new Thread(new Poller(null));
        thread.setName(this.getClass().getName());
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        this.getLogger().fine("Polling thread started");
    }

    private synchronized void _transitionPollingToDisabled() {
        if (!$assertionsDisabled && this._state != 1) {
            throw new AssertionError();
        }
        this._state = 2;
        this.getLogger().fine("Transitioning from polling to disabled");
    }

    private synchronized void _transitionDisabledToPolling() {
        if (!$assertionsDisabled && this._state != 2) {
            throw new AssertionError();
        }
        this._state = 1;
        this.getLogger().fine("Transitioning from disabled to polling");
    }

    private Transferable _getContentsDirectly() {
        try {
            Transferable transferable = this._clipboard.getContents(this);
            if (transferable == null) {
                transferable = ClipboardManager.EMPTY_CONTENTS;
            }
            this.getLogger().log(Level.FINER, "Fetched clipboard contents: {0}", transferable);
            ExtendedTransferable extendedTransferable = ExtendedTransferable.getExtendedTransferable((Transferable)transferable);
            if (extendedTransferable != null) {
                transferable = extendedTransferable;
            }
            Transferable transferable2 = transferable;
            return transferable2;
        }
        catch (IllegalStateException illegalStateException) {
            this.getLogger().log(Level.FINE, "Got IllegalStateException fetching clipboard contents!", illegalStateException);
            Transferable transferable = ClipboardManager.UNKNOWN_CONTENTS;
            return transferable;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.getLogger().log(Level.FINE, "Got unexpected exception fetching clipboard contents!", throwable);
            Transferable transferable = ClipboardManager.UNKNOWN_CONTENTS;
            return transferable;
        }
    }

    private synchronized void _updateCachedContents(Transferable transferable) {
        Transferable transferable2;
        if (transferable == null) {
            transferable = ClipboardManager.EMPTY_CONTENTS;
        }
        if (transferable != (transferable2 = this._cached())) {
            Transferable transferable3 = transferable2;
            this._cachedContentsRef = new SoftReference<Transferable>(transferable);
            if (transferable3 == null || PollingClipboardManager.areDifferent(transferable3.getTransferDataFlavors(), transferable.getTransferDataFlavors())) {
                this.notifyFlavorListeners();
            }
        }
    }

    private synchronized boolean _isInPollingState() {
        return this._state == 1;
    }

    private synchronized Transferable _cached() {
        return this._cachedContentsRef == null ? null : (Transferable)this._cachedContentsRef.get();
    }

    void $init$() {
        this._state = 0;
        this._ownsClipboard = false;
        this._cachedContentsRef = null;
        this._clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this._owner = new Owner(null);
    }

    static void mav$_setClipboardOwnership(PollingClipboardManager pollingClipboardManager, boolean bl) {
        pollingClipboardManager._setClipboardOwnership(bl);
    }

    static int ra$_state(PollingClipboardManager pollingClipboardManager) {
        return pollingClipboardManager._state;
    }

    static boolean mav$_isInPollingState(PollingClipboardManager pollingClipboardManager) {
        return pollingClipboardManager._isInPollingState();
    }

    static Transferable mav$_getContentsDirectly(PollingClipboardManager pollingClipboardManager) {
        return pollingClipboardManager._getContentsDirectly();
    }

    static void mav$_updateCachedContents(PollingClipboardManager pollingClipboardManager, Transferable transferable) {
        pollingClipboardManager._updateCachedContents(transferable);
    }

    private class Owner
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            PollingClipboardManager.mav$_setClipboardOwnership(PollingClipboardManager.this, false);
        }

        private Owner() {
        }

        Owner(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Poller
    implements Runnable {
        static final /* synthetic */ boolean $assertionsDisabled;
        private long _msUntilNextPoll;

        static {
            $assertionsDisabled = Poller.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PollingClipboardManager pollingClipboardManager = PollingClipboardManager.this;
            synchronized (pollingClipboardManager) {
                if (!$assertionsDisabled && PollingClipboardManager.ra$_state(PollingClipboardManager.this) == 0) {
                    throw new AssertionError();
                }
            }
            while (true) {
                if (PollingClipboardManager.mav$_isInPollingState(PollingClipboardManager.this)) {
                    long l = System.currentTimeMillis();
                    Transferable transferable = PollingClipboardManager.mav$_getContentsDirectly(PollingClipboardManager.this);
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    if (PollingClipboardManager.this.getLogger().isLoggable(Level.FINER)) {
                        PollingClipboardManager.this.getLogger().log(Level.FINER, "Background clipboard poll in {0} ms", new Long(l3));
                    }
                    PollingClipboardManager.mav$_updateCachedContents(PollingClipboardManager.this, transferable);
                    if (l3 < (long)100) {
                        if (this._msUntilNextPoll != 1000L) {
                            PollingClipboardManager.this.getLogger().finer("Clipboard poll time reset to minimum");
                            this._msUntilNextPoll = 1000L;
                        }
                    } else {
                        this._msUntilNextPoll = 1000L + (long)5 * l3;
                        if (PollingClipboardManager.this.getLogger().isLoggable(Level.FINER)) {
                            PollingClipboardManager.this.getLogger().log(Level.FINER, "Clipboard poll time set to {0} ms", new Long(this._msUntilNextPoll));
                        }
                    }
                }
                try {
                    Thread.sleep(this._msUntilNextPoll);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        void $init$() {
            this._msUntilNextPoll = 1000L;
        }

        private Poller() {
            this.$init$();
        }

        Poller(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

