/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.string;

public final class StringChange {
    private final int _offset;
    private final String _insertedChars;
    private final int _removalCount;
    public static final short INSERTION = 0;
    public static final short REMOVAL = 1;
    public static final short REPLACEMENT = 2;
    public static final short NO_CHANGE = 3;

    public StringChange(int n, String string, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("negative offset");
        }
        if ("".equals(string)) {
            string = null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this._insertedChars = string;
        this._removalCount = n2;
        this._offset = this.getChangeType() == 3 ? 0 : n;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getRemovalCount() {
        return this._removalCount;
    }

    public int getInsertionCount() {
        return this._insertedChars == null ? 0 : this._insertedChars.length();
    }

    public String getInsertedChars() {
        return this._insertedChars;
    }

    public short getChangeType() {
        if (this._removalCount > 0) {
            if (this._insertedChars != null) {
                return 2;
            }
            return 1;
        }
        if (this._insertedChars != null) {
            return 0;
        }
        return 3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("StringChange(offset=");
        stringBuffer.append(this._offset);
        if (this._insertedChars != null) {
            stringBuffer.append(", insertedChars=");
            stringBuffer.append(this._insertedChars);
        }
        if (this._removalCount > 0) {
            stringBuffer.append(", removalCount=");
            stringBuffer.append(this._removalCount);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

