/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.tools;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.tools.StandaloneXmlContext;
import oracle.bali.xml.util.DefaultPrefixLookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class MetadataUpgrader {
    private static final String _MD_NS = "http://xmlns.oracle.com/bali/xml/metadata";
    private static final Map _MAPPINGS = Collections.unmodifiableMap(MetadataUpgrader._createMappings());

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        MetadataUpgrader.upgradeFile(file);
    }

    public static void upgradeFile(File file) throws Exception {
        System.out.println("Upgrading file " + file.getName());
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                MetadataUpgrader.upgradeFile(fileArray[n]);
                ++n;
            }
        } else {
            URL uRL = file.toURL();
            MetadataUpgrader.upgradeURL(uRL);
        }
    }

    public static void upgradeURL(URL uRL) throws Exception {
        StandaloneXmlContext standaloneXmlContext = new StandaloneXmlContext(uRL);
        MetadataUpgrader._doUpgrade(standaloneXmlContext);
        standaloneXmlContext.save(uRL);
    }

    public static void upgrade(InputStream inputStream, OutputStream outputStream) throws Exception {
        StandaloneXmlContext standaloneXmlContext = new StandaloneXmlContext(inputStream);
        MetadataUpgrader._doUpgrade(standaloneXmlContext);
        standaloneXmlContext.save(outputStream);
    }

    public static Map getMappings() {
        return _MAPPINGS;
    }

    private static void _doUpgrade(XmlContext xmlContext) throws Exception {
        XmlModel xmlModel = xmlContext.getSourceModel();
        Map map = MetadataUpgrader.getMappings();
        boolean bl = false;
        xmlModel.startTransaction("upgrade metadata");
        try {
            Node node;
            Document document = xmlModel.getDocument();
            DocumentTraversal documentTraversal = (DocumentTraversal)((Object)document);
            NodeIterator nodeIterator = documentTraversal.createNodeIterator(document.getDocumentElement(), 1, null, false);
            while ((node = nodeIterator.nextNode()) != null) {
                String string;
                LinkedList<Node> linkedList = new LinkedList<Node>();
                if (_MD_NS.equals(node.getNamespaceURI()) && (string = (String)map.get(node.getLocalName())) != null) {
                    linkedList.add(node);
                }
                for (Node node2 : linkedList) {
                    String string2 = (String)map.get(node2.getLocalName());
                    Node node3 = node2.getParentNode();
                    Element element = document.createElementNS(_MD_NS, string2);
                    String string3 = node2.getFirstChild().getNodeValue().trim();
                    Text text = document.createTextNode("${md:getTranslatedString(\"" + string3 + "\")}");
                    element.appendChild(text);
                    xmlModel.fixPrefixes(node3, element, new MdPrefixLookup(null));
                    System.out.println("replacing " + node2.getLocalName() + " with " + element.getLocalName());
                    node3.replaceChild(element, node2);
                }
            }
            xmlModel.commitTransaction(true);
            bl = true;
        }
        finally {
            if (!bl) {
                xmlModel.rollbackTransaction();
            }
        }
    }

    private static Map _createMappings() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("shortDescriptionKey", "shortDescription");
        hashMap.put("palettePageKey", "group");
        hashMap.put("displayNameKey", "shortDisplayName");
        hashMap.put("groupKey", "group");
        return hashMap;
    }

    private static class MdPrefixLookup
    implements DefaultPrefixLookup {
        public String getDefaultPrefix(String string) {
            if (MetadataUpgrader._MD_NS.equals(string)) {
                return "md";
            }
            return null;
        }

        private MdPrefixLookup() {
        }

        MdPrefixLookup(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

