/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.tools.StandaloneXmlContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StandaloneMetadataCleanupTool {
    public static final void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("usage:  StandaloneMetadataCleanupTool metadataInput");
            System.exit(1);
        }
        String string = stringArray[0];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("file not found " + string);
            System.exit(1);
        }
        try {
            StandaloneXmlContext standaloneXmlContext = new StandaloneXmlContext(fileInputStream);
            boolean bl = new 1("Cleanup metadata file").run(standaloneXmlContext.getModel());
            fileInputStream.close();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            standaloneXmlContext.save(fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean _checkElement(Element element) {
        if (element == null || !"grammarMetadata".equals(element.getLocalName()) && !"elementMetadata".equals(element.getLocalName()) && !"attributeMetadata".equals(element.getLocalName())) {
            return false;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength() - 1;
        while (n >= 0) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                if (StandaloneMetadataCleanupTool._checkElement((Element)node)) {
                    element.removeChild(node);
                }
            } else if (node.getNodeType() == 3 && StandaloneMetadataCleanupTool._isEmpty(node.getNodeValue())) {
                element.removeChild(node);
            }
            --n;
        }
        return element.getChildNodes().getLength() <= 0;
    }

    private static boolean _isEmpty(String string) {
        return "".equals(string.trim());
    }

    static boolean maS$_checkElement(Element element) {
        return StandaloneMetadataCleanupTool._checkElement(element);
    }

    public static final class 1
    extends FixedNameTransactionTask {
        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            try {
                StandaloneMetadataCleanupTool.maS$_checkElement(abstractModel.getDocument().getDocumentElement());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public 1(String string) {
            super(string);
        }
    }
}

