/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.tools.StandaloneXmlUpdater;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.xml.parser.v2.XMLDOMImplementation;
import org.w3c.dom.DOMImplementation;

public class StandaloneXmlContext
extends XmlContext {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final TextBuffer _buffer;

    public StandaloneXmlContext(URL uRL) throws IOException {
        this(uRL, null);
    }

    public StandaloneXmlContext(InputStream inputStream) throws IOException {
        this(null, inputStream);
    }

    static {
        $assertionsDisabled = StandaloneXmlContext.class.desiredAssertionStatus() ^ true;
    }

    private StandaloneXmlContext(URL uRL, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            if (!$assertionsDisabled && uRL == null) {
                throw new AssertionError();
            }
            inputStream = uRL.openStream();
        }
        try {
            String string = "UTF-8";
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            this._buffer = TextBufferFactory.createTextBuffer();
            this._buffer.read((Reader)inputStreamReader);
            this.setModel(this.createXmlModel());
            this.finishInitialization();
        }
        finally {
            if (uRL != null) {
                inputStream.close();
            }
        }
    }

    public static void updateFile(String string, StandaloneXmlUpdater standaloneXmlUpdater) {
        try {
            URL uRL = new File(string).toURL();
            StandaloneXmlContext standaloneXmlContext = new StandaloneXmlContext(uRL);
            standaloneXmlContext.getLogger().addHandler(new StreamHandler(System.out, new SimpleFormatter()));
            standaloneXmlUpdater.updateModel(standaloneXmlContext.getModel());
            standaloneXmlContext.save(uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public URL getURLForRelativePath(String string) {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getRelativePathForURL(URL uRL) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void save(OutputStream outputStream) throws IOException {
        String string = "UTF-8";
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        this._buffer.write((Writer)outputStreamWriter, false);
    }

    public void save(URL uRL) throws IOException {
        OutputStream outputStream = uRL.openConnection().getOutputStream();
        try {
            this.save(outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    protected XmlModel createXmlModel() {
        return new XmlModel();
    }

    protected DomModel createSourceDomModel(XmlModel xmlModel) {
        BufferDomModel bufferDomModel = new BufferDomModel(this, this._buffer, (DOMImplementation)new XMLDOMImplementation(), new DefaultParserConfiguration(), xmlModel.getWhitespaceHandler());
        return bufferDomModel;
    }
}

