/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.translation;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.translation.TranslationSource;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdeveloper.model.PathsConfiguration;

public class ListResourceBundleSource
implements TranslationSource {
    private Map _resources;
    private SourceFactory _factory;
    private final JavaManager _javaManager;
    private final String _qualifiedClassName;
    private SourceClass _sourceNode;
    private SourceListExpression _contentsArray;
    private boolean _isReadOnly;
    private int _currentExpressionIndex;
    private Project _project;
    private boolean _notInitialized;
    private static String _BASE_IMPORT = "java.util.ListResourceBundle";
    private static String _BASE_CLASS = "ListResourceBundle";
    private static String _CONTENTS_METHOD = "getContents";
    private static String _CONTENTS_RETURN_TYPE = "Object[][]";
    private static String _CONTENTS_FIELD = "static final Object[][]";
    private static String _CONTENTS_METHOD_TEXT = "return contents;";
    private static String _CONTENTS_ARRAY_DECL = "{}";
    private static final Logger _LOG = Logger.getLogger("oracle.bali.xml.translation.ListResourceBundleSource");
    private static final String _NEWFILE_TEMPLATE = "{0}/{1}.java";
    private static final String _EXPRESSION_TEMPLATE = "'{'\n\"{0}\", \"{1}\"'}'";
    private static final String _DEFAULT_FIELD_NAME = "contents";

    public ListResourceBundleSource(String string, Project project) {
        this.$init$();
        this._project = project;
        this._javaManager = JavaManager.getJavaManager((Project)project);
        this._qualifiedClassName = string;
        if (!this._nodeExists()) {
            this._generateNewSource();
        }
        this.reinitialize();
    }

    public String getString(String string) {
        String string2;
        TranslatableHolder translatableHolder;
        if (this._notInitialized) {
            return "";
        }
        if (this._resources == null) {
            this._catalogResources();
        }
        if ((translatableHolder = (TranslatableHolder)this._resources.get(string)) != null && (string2 = translatableHolder.getValue()) != null) {
            return string2;
        }
        return "";
    }

    public void setString(String string, String string2) {
        if (this._notInitialized) {
            return;
        }
        if (this._resources == null) {
            this._catalogResources();
        }
        SourceTransaction sourceTransaction = this._sourceNode.getOwningSourceFile().beginTransaction();
        String string3 = this._createExpressionString(string, string2);
        TranslatableHolder translatableHolder = (TranslatableHolder)this._resources.get(string);
        if (translatableHolder != null) {
            if (!translatableHolder.getValue().equals(string2)) {
                this._contentsArray.getChildren().add(translatableHolder.getIndex(), this._factory.createExpressionFromText(string3));
                translatableHolder.setValue(string2);
            }
        } else {
            this._contentsArray.getChildren().add(this._factory.createExpressionFromText(string3));
        }
        this._commitDocument(sourceTransaction, string3);
        this.reinitialize();
    }

    public void resetCache() {
        this._resources = null;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    protected void reinitialize() {
        try {
            SourceFieldVariable sourceFieldVariable;
            SourceFile sourceFile = this._javaManager.getSourceFile(URLFactory.newURL((String)this._generateFilePath()));
            SourceClass sourceClass = sourceFile.getSourceClass(this._qualifiedClassName);
            if (sourceClass != null && (sourceFieldVariable = (SourceFieldVariable)sourceClass.getDeclaredField(_DEFAULT_FIELD_NAME)) != null) {
                SourceExpression sourceExpression = sourceFieldVariable.getInitializer();
                if (sourceExpression == null) {
                    return;
                }
                if (!(sourceExpression instanceof SourceListExpression)) {
                    return;
                }
                this._sourceNode = sourceClass;
                this._contentsArray = (SourceListExpression)sourceExpression;
                this.resetCache();
                this._isReadOnly = false;
                this._notInitialized = false;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            _LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
    }

    private void _generateNewSource() {
        URL uRL = URLFactory.newURL((String)this._generateFilePath());
        int n = this._qualifiedClassName.lastIndexOf(".");
        String string = null;
        String string2 = null;
        if (n != -1) {
            string = this._qualifiedClassName.substring(n + 1);
            string2 = this._qualifiedClassName.substring(0, n);
        } else {
            string = this._qualifiedClassName;
        }
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            SourceFile sourceFile = this._javaManager.getSourceFile(uRL);
            this._factory = sourceFile.getFactory();
            SourceTransaction sourceTransaction = sourceFile.beginTransaction();
            if (string2 != null) {
                sourceFile.setPackageName(string2);
            }
            List list = sourceFile.getSourceImports();
            SourceImport sourceImport = this._factory.createImportDeclaration(_BASE_IMPORT);
            list.add(sourceImport);
            SourceClass sourceClass = this._factory.createClass(string);
            sourceClass.setSourceSuperclass(this._factory.createType(_BASE_CLASS));
            sourceClass.setModifiers(1);
            SourceMethod sourceMethod = this._factory.createMethod(this._factory.createType(_CONTENTS_RETURN_TYPE), _CONTENTS_METHOD, null, null, this._factory.createBlockFromText(_CONTENTS_METHOD_TEXT));
            sourceMethod.setModifiers(1);
            sourceClass.getMethods().add(sourceMethod);
            SourceFieldDeclaration sourceFieldDeclaration = this._factory.createFieldDeclaration(24, this._factory.createTypeFromText(_CONTENTS_RETURN_TYPE), _DEFAULT_FIELD_NAME, this._factory.createExpressionFromText(_CONTENTS_ARRAY_DECL));
            sourceClass.getFields().add(sourceFieldDeclaration);
            TransactionDescriptor transactionDescriptor = new TransactionDescriptor("creation");
            this._javaManager.commitTransaction(sourceTransaction, transactionDescriptor);
            this._project.add((Element)node, true);
        }
        catch (Exception exception) {
            this._logException(exception);
        }
    }

    private void _commitDocument(SourceTransaction sourceTransaction, String string) {
        try {
            this._javaManager.commitTransaction(sourceTransaction, new TransactionDescriptor(string));
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            sourceTransaction.abort();
        }
    }

    private boolean _nodeExists() {
        URL uRL = URLFactory.newURL((String)this._generateFilePath());
        return NodeFactory.find((URL)uRL) != null;
    }

    private String _generateFilePath() {
        String string = this._qualifiedClassName.replace('.', '/');
        return FastMessageFormat.formatMessage(_NEWFILE_TEMPLATE, (Object[])new String[]{PathsConfiguration.getInstance((Project)this._project).getSourcePath().toStrings()[0], string});
    }

    private String _createExpressionString(String string, String string2) {
        return FastMessageFormat.formatMessage(_EXPRESSION_TEMPLATE, (Object[])new String[]{string, string2});
    }

    private void _catalogResources() {
        this._resources = new HashMap();
        this._currentExpressionIndex = 0;
        int n = this._contentsArray.getOperandCount();
        int n2 = 0;
        while (n2 < n) {
            SourceExpression sourceExpression = this._contentsArray.getOperandAt(n2);
            if (sourceExpression != null) {
                this._addExpressionToMap(sourceExpression.getText(), this._resources, n2);
            }
            this._currentExpressionIndex = n2++;
        }
    }

    private void _addExpressionToMap(String string, Map map, int n) {
        if (string == null || !"".equals(string)) {
            String[] stringArray = (string = string.substring(1, string.length() - 1)).split(",");
            if (stringArray.length != 2) {
                return;
            }
            String string2 = this._extractQuotes(stringArray[0]);
            String string3 = this._extractQuotes(stringArray[1]);
            map.put(string2, new TranslatableHolder(string3, n));
        }
    }

    private String _extractQuotes(String string) {
        if (string == null || string.length() < 3) {
            return string;
        }
        int n = string.indexOf(34);
        int n2 = string.lastIndexOf(34);
        return string.substring(n + 1, n2);
    }

    private void _logException(Throwable throwable) {
        _LOG.log(Level.WARNING, throwable.getLocalizedMessage(), throwable);
    }

    void $init$() {
        this._isReadOnly = true;
        this._currentExpressionIndex = 0;
        this._notInitialized = true;
    }

    private static final class TranslatableHolder {
        private String _value;
        private final int _index;

        public TranslatableHolder(String string, int n) {
            this._value = string;
            this._index = n;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String string) {
            this._value = string;
        }

        public int getIndex() {
            return this._index;
        }
    }
}

