/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.translation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.translation.TranslationSource;

public class PropertyResourceBundleSource
implements TranslationSource {
    private boolean _isLoaded;
    private final String _qualifiedName;
    private Properties _properties;
    private static final Logger _LOG = Logger.getLogger("oracle.bali.xml.translation.PropertyResourceBundleSource");

    public PropertyResourceBundleSource(String string) {
        this.$init$();
        this._qualifiedName = string;
    }

    public String getString(String string) {
        if (this._properties == null) {
            if (this._isLoaded) {
                return null;
            }
            this._buildProperties();
        }
        if (this._properties == null) {
            return null;
        }
        return this._properties.getProperty(string);
    }

    public void setString(String string, String string2) {
        if (this._properties == null) {
            if (this._isLoaded) {
                return;
            }
            this._buildProperties();
        }
        if (this._properties == null) {
            return;
        }
        this._properties.setProperty(string, string2);
        this._saveProperties();
    }

    public boolean isReadOnly() {
        return true;
    }

    private void _buildProperties() {
        this._isLoaded = true;
        InputStream inputStream = this._getSourceInputStream();
        if (inputStream != null) {
            this._properties = new Properties();
            try {
                this._properties.load(inputStream);
            }
            catch (IOException iOException) {
                this._logException(iOException);
            }
        }
    }

    private void _saveProperties() {
        if (!this._isLoaded || this._properties == null) {
            return;
        }
        OutputStream outputStream = this._getSourceOutputStream();
        if (outputStream == null) {
            return;
        }
        try {
            this._properties.store(outputStream, null);
        }
        catch (IOException iOException) {
            this._logException(iOException);
        }
    }

    private InputStream _getSourceInputStream() {
        return this.getClass().getClassLoader().getResourceAsStream(this._qualifiedName);
    }

    private OutputStream _getSourceOutputStream() {
        URL uRL = this.getClass().getClassLoader().getResource(this._qualifiedName);
        try {
            File file = new File(uRL.toExternalForm());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            return fileOutputStream;
        }
        catch (IOException iOException) {
            this._logException(iOException);
            OutputStream outputStream = null;
            return outputStream;
        }
    }

    private void _logException(Throwable throwable) {
        _LOG.log(Level.WARNING, throwable.getMessage(), throwable);
    }

    void $init$() {
        this._isLoaded = false;
    }
}

