/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.translation;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.metadata.ContextualPropertyEditor;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.share.PropertyEditorProxy;
import oracle.bali.xml.translation.BaseTranslationsProvider;
import oracle.bali.xml.translation.TranslationSource;
import oracle.bali.xml.translation.TranslationsProvider;
import oracle.javatools.util.SwingUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class SimpleTranslationsPropertyEditor
extends PropertyEditorProxy
implements ContextualPropertyEditor {
    private static final String _DEFAULT_NO_RESOURCE_STRING = "<no resource>";
    private ListenerManager _listManager;
    private String _value;
    private String _key;
    private TranslationSource _source;

    public SimpleTranslationsPropertyEditor(PropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    public void clearContext() {
        this._setContext(null, null, null, null);
    }

    public void setContext(PropertyEditorContext propertyEditorContext) {
        this._setContext(propertyEditorContext.getXmlContext(), propertyEditorContext.getKey(), propertyEditorContext.getNode(), propertyEditorContext.getOwnerNode());
    }

    private void _setContext(XmlContext xmlContext, XmlKey xmlKey, Node node, Node node2) {
        if (xmlContext != null && node != null && node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            this._key = attr.getNodeValue();
            XmlModel xmlModel = xmlContext.getModel();
            TranslationsProvider translationsProvider = xmlContext.getModel().getXmlMetadataResolver().getTranslationsProvider(attr);
            if (translationsProvider != null) {
                if (translationsProvider instanceof BaseTranslationsProvider) {
                    ((BaseTranslationsProvider)((Object)translationsProvider)).__ensureContextAttached(xmlContext);
                }
                this._source = translationsProvider.getTranslationSource(attr, xmlKey);
            }
        }
    }

    public void setValue(Object object) {
        this._key = (String)object;
    }

    public void setResourceValue(String string) {
        String string2 = this.getAsText();
        if (this._source != null) {
            this._source.setString(this._key, string);
        } else {
            this._value = string;
        }
        this._firePropertyChanged(string2, string);
    }

    public Object getValue() {
        return this._key != null ? this._key.toString() : "";
    }

    public String getResourceValue() {
        if (this._source != null) {
            return this._source.getString(this._key);
        }
        return this._value;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = this.getResourceValue();
        if (string == null || "".equals(string)) {
            string = _DEFAULT_NO_RESOURCE_STRING;
        }
        SwingUtils.drawString((Graphics)graphics, (String)string, (int)2, (int)((int)rectangle.getHeight() - 3));
    }

    public String getJavaInitializationString() {
        return "";
    }

    public String getAsText() {
        return (String)this.getValue();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText("You can change the translated value in your resource bundle below. Afterwards, you will need to save that bundle for the changes to be in affect.");
        jPanel.add((Component)multiLineLabel);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JTextField jTextField = new JTextField(30);
        jTextField.setText(this.getResourceValue());
        jTextField.addPropertyChangeListener(new 1(this, jTextField));
        String string = "&Translated Value:";
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel.setLabelFor(jTextField);
        jPanel2.add(jLabel);
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public boolean supportsCustomEditor() {
        return this._source != null && !this._source.isReadOnly();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._listManager == null) {
            this._listManager = new ListenerManager();
        }
        this._listManager.addListener((EventListener)propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._listManager == null) {
            return;
        }
        this._listManager.removeListener((EventListener)propertyChangeListener);
    }

    private void _firePropertyChanged(String string, String string2) {
        if (this._listManager == null) {
            return;
        }
        Enumeration enumeration = this._listManager.getListeners();
        while (enumeration.hasMoreElements()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, null, string, string2));
        }
    }

    public final class 1
    implements PropertyChangeListener {
        private final /* synthetic */ JTextField v$valueField;
        final /* synthetic */ SimpleTranslationsPropertyEditor this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = this.v$valueField.getText();
            this.this$0.setResourceValue(string);
        }

        public 1(SimpleTranslationsPropertyEditor simpleTranslationsPropertyEditor, JTextField jTextField) {
            this.v$valueField = jTextField;
            this.this$0 = simpleTranslationsPropertyEditor;
        }
    }
}

