/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.Iterator;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.event.XmlModelAdapter;
import org.w3c.dom.Node;

public abstract class AbstractTextSelectionSynchronizer
extends XmlModelAdapter {
    public void modelChanged(XmlModelEvent xmlModelEvent) {
        if (xmlModelEvent.isSelectionOrRangeSelectionChanged()) {
            this.syncTextSelection((GuiXmlContext)xmlModelEvent.getModel().getContext());
        }
    }

    public final void syncTextSelection(GuiXmlContext guiXmlContext) {
        this.syncTextSelection(guiXmlContext, null);
    }

    public final void syncTextSelection(GuiXmlContext guiXmlContext, Object object) {
        XmlModel xmlModel = guiXmlContext.getModel();
        Selection selection = xmlModel.getSelection();
        if (this.shouldSyncTextSelection(guiXmlContext)) {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            xmlModel.acquireReadLock();
            try {
                if (selection.hasRangeSelection()) {
                    int n3;
                    DomRange domRange = selection.getRangeSelection();
                    int n4 = xmlModel.getTextOffset(domRange.getStart());
                    if (n4 != -1) {
                        n = n4;
                    }
                    if ((n3 = xmlModel.getTextOffset(domRange.getEnd())) != -1) {
                        n2 = n3;
                    }
                } else {
                    Iterator iterator = selection.getSelectedNodes();
                    while (iterator.hasNext()) {
                        int n5;
                        Node node = (Node)iterator.next();
                        if (node.getNodeType() == 9) continue;
                        int n6 = xmlModel.getTextOffset(DomPositionFactory.createDomPosition((Node)node, (int)1));
                        if (n6 != -1) {
                            n = Math.min(n, n6);
                        }
                        if ((n5 = xmlModel.getTextOffset(DomPositionFactory.createDomPosition((Node)node, (int)2))) == -1) continue;
                        n2 = Math.max(n2, n5);
                    }
                }
            }
            finally {
                xmlModel.releaseReadLock();
            }
            if (n != Integer.MAX_VALUE && n2 != Integer.MIN_VALUE) {
                this.syncTextSelection(xmlModel, n, n2, object);
            }
        }
    }

    protected boolean shouldSyncTextSelection(GuiXmlContext guiXmlContext) {
        XmlGui xmlGui = guiXmlContext.getActiveGui();
        if (xmlGui != null) {
            return xmlGui.getUsage() != XmlUsage.XML_CODE_EDITOR;
        }
        return true;
    }

    public abstract void syncTextSelection(XmlModel var1, int var2, int var3, Object var4);
}

