/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class CollectionUtils {
    public static final int ASSUME_UNMODIFIABLE = 0;
    public static final int ASSUME_MODIFIABLE = 1;
    public static final int RETURN_EXACT_RESULT = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Object _COLLECTION_CONTENT;
    private static final Map _SINGLETON_MAP;
    private static final Set _SINGLETON_SET;
    private static final Class _SINGLETON_LIST_CLASS;
    private static final Class _SINGLETON_MAP_CLASS;
    private static final Class _SINGLETON_SET_CLASS;
    private static final Class _UNMODIFIABLE_LIST_CLASS;
    private static final Class _UNMODIFIABLE_MAP_CLASS;
    private static final Class _UNMODIFIABLE_SET_CLASS;
    private static final Class _ARRAY_LIST_CLASS;
    private static final Class _LINKED_LIST_CLASS;
    private static final Class _HASH_MAP_CLASS;
    private static final Class _IDENTITY_HASH_MAP_CLASS;
    private static final Class _LINKED_HASH_MAP_CLASS;
    private static final Class _TREE_MAP_CLASS;
    private static final Class _HASH_SET_CLASS;
    private static final Class _LINKED_HASH_SET_CLASS;
    private static final Class _TREE_SET_CLASS;

    static {
        $assertionsDisabled = CollectionUtils.class.desiredAssertionStatus() ^ true;
        _COLLECTION_CONTENT = new Object();
        _SINGLETON_MAP = Collections.singletonMap(_COLLECTION_CONTENT, _COLLECTION_CONTENT);
        _SINGLETON_SET = Collections.singleton(_COLLECTION_CONTENT);
        _SINGLETON_LIST_CLASS = Collections.singletonList(_COLLECTION_CONTENT).getClass();
        _SINGLETON_MAP_CLASS = _SINGLETON_MAP.getClass();
        _SINGLETON_SET_CLASS = _SINGLETON_SET.getClass();
        _UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(new LinkedList()).getClass();
        _UNMODIFIABLE_MAP_CLASS = Collections.unmodifiableMap(_SINGLETON_MAP).getClass();
        _UNMODIFIABLE_SET_CLASS = Collections.unmodifiableSet(_SINGLETON_SET).getClass();
        _ARRAY_LIST_CLASS = new ArrayList(0).getClass();
        _LINKED_LIST_CLASS = new LinkedList().getClass();
        _HASH_MAP_CLASS = new HashMap(0).getClass();
        _IDENTITY_HASH_MAP_CLASS = new IdentityHashMap(0).getClass();
        _LINKED_HASH_MAP_CLASS = new LinkedHashMap(0).getClass();
        _TREE_MAP_CLASS = new TreeMap().getClass();
        _HASH_SET_CLASS = new HashSet(0).getClass();
        _LINKED_HASH_SET_CLASS = new LinkedHashSet(0).getClass();
        _TREE_SET_CLASS = new TreeSet().getClass();
    }

    public static List makeListOfLists(List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            list.set(n2, Collections.singletonList(list.get(n2)));
            ++n2;
        }
        return list;
    }

    public static List makeListOfLists(List list, List list2) {
        if (list2 == null || list2.size() == 0) {
            return CollectionUtils.makeListOfLists(list);
        }
        int n = list2.size() + 1;
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            ArrayList arrayList = new ArrayList(n);
            arrayList.addAll(list2);
            arrayList.add(list.get(n3));
            list.set(n3, arrayList);
            ++n3;
        }
        return list;
    }

    public static boolean isUnmodifiableList(List list, int n) {
        if (list == null) {
            return false;
        }
        Class<?> clazz = list.getClass();
        if (clazz == _ARRAY_LIST_CLASS || clazz == _LINKED_LIST_CLASS) {
            return false;
        }
        if (clazz == Collections.EMPTY_LIST.getClass() || _SINGLETON_LIST_CLASS.isInstance(list) || _UNMODIFIABLE_LIST_CLASS.isInstance(list)) {
            return true;
        }
        switch (n) {
            default: {
                try {
                    list.add(_COLLECTION_CONTENT);
                    list.remove(list.size() - 1);
                    boolean bl = false;
                    return bl;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    boolean bl = true;
                    return bl;
                }
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return false;
    }

    public static boolean isUnmodifiableMap(Map map, int n) {
        if (map == null) {
            return false;
        }
        Class<?> clazz = map.getClass();
        if (clazz == _HASH_MAP_CLASS || clazz == _TREE_MAP_CLASS || clazz == _LINKED_HASH_MAP_CLASS || clazz == _IDENTITY_HASH_MAP_CLASS) {
            return false;
        }
        if (clazz == Collections.EMPTY_MAP.getClass() || _SINGLETON_MAP_CLASS.isInstance(map) || _UNMODIFIABLE_MAP_CLASS.isInstance(map)) {
            return true;
        }
        switch (n) {
            default: {
                try {
                    map.put(_COLLECTION_CONTENT, _COLLECTION_CONTENT);
                    map.remove(_COLLECTION_CONTENT);
                    boolean bl = false;
                    return bl;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    boolean bl = true;
                    return bl;
                }
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return false;
    }

    public static boolean isUnmodifiableSet(Set set, int n) {
        if (set == null) {
            return false;
        }
        Class<?> clazz = set.getClass();
        if (clazz == _HASH_SET_CLASS || clazz == _LINKED_HASH_SET_CLASS || clazz == _TREE_SET_CLASS) {
            return false;
        }
        if (clazz == Collections.EMPTY_SET.getClass() || _SINGLETON_SET_CLASS.isInstance(set) || _UNMODIFIABLE_SET_CLASS.isInstance(set)) {
            return true;
        }
        switch (n) {
            default: {
                try {
                    set.add(_COLLECTION_CONTENT);
                    set.remove(_COLLECTION_CONTENT);
                    boolean bl = false;
                    return bl;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    boolean bl = true;
                    return bl;
                }
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return false;
    }

    public static List createUnmodifiableList(List list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n > 1) {
            if (CollectionUtils.isUnmodifiableList(list, 1)) {
                return list;
            }
            return Collections.unmodifiableList(list);
        }
        if (n == 1) {
            return Collections.singletonList(list.get(0));
        }
        return Collections.EMPTY_LIST;
    }

    public static Map createUnmodifiableMap(Map map) {
        if (map == null) {
            return null;
        }
        int n = map.size();
        if (n >= 1) {
            if (CollectionUtils.isUnmodifiableMap(map, 1)) {
                return map;
            }
            return Collections.unmodifiableMap(map);
        }
        return Collections.EMPTY_MAP;
    }

    public static Set createUnmodifiableSet(Set set) {
        if (set == null) {
            return null;
        }
        int n = set.size();
        if (n > 1) {
            if (CollectionUtils.isUnmodifiableSet(set, 1)) {
                return set;
            }
            return Collections.unmodifiableSet(set);
        }
        if (n == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return Collections.EMPTY_SET;
    }

    public static Set mergeAddRemoveSets(Set hashSet, Set set, Set set2) {
        boolean bl;
        boolean bl2 = bl = hashSet != null && !hashSet.isEmpty();
        if (set2 == null || set2.isEmpty()) {
            if (bl) {
                hashSet.addAll(set);
            } else {
                hashSet = set;
            }
        } else {
            if (!bl) {
                hashSet = new HashSet((int)((double)set.size() * 1.5));
            }
            for (Object e : set) {
                if (set2.remove(e)) continue;
                hashSet.add(e);
            }
        }
        return hashSet;
    }

    public static void computeAddRemoveSets(Set set, Set set2, Set set3, Set set4) {
        set3.addAll(set2);
        set3.removeAll(set);
        set4.addAll(set);
        set4.removeAll(set2);
    }

    public static Object[] toArray(Collection collection, Object[] objectArray, Predicate predicate) {
        if (predicate == null) {
            return collection.toArray(objectArray);
        }
        int n = collection.size();
        Object[] objectArray2 = CollectionUtils.createArray(objectArray, n);
        int n2 = 0;
        for (Object e : collection) {
            if (!predicate.accept(e)) continue;
            objectArray2[n2] = e;
            ++n2;
        }
        if (n2 == n) {
            return objectArray2;
        }
        if (!$assertionsDisabled && n2 >= n) {
            throw new AssertionError();
        }
        Object[] objectArray3 = CollectionUtils.createArray(objectArray, n2);
        System.arraycopy(objectArray2, 0, objectArray3, 0, n2);
        return objectArray3;
    }

    public static Object[] createArray(Object[] objectArray, int n) {
        return (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
    }

    private CollectionUtils() {
    }

    public static interface Predicate {
        public boolean accept(Object var1);
    }
}

