/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;

public abstract class DomPositionMapper {
    private final AbstractModel _model;
    private final DomPosition _cursor;
    private final DomPosition _drop;
    private final DomRange _range;

    public DomPositionMapper(AbstractModel abstractModel) {
        this._model = abstractModel;
        Selection selection = this._model.getSelection();
        this._cursor = selection.getCursorLocation();
        this._drop = selection.getDropLocation();
        this._range = selection.getRangeSelection();
    }

    public void applyMappings() {
        Selection selection = this._model.getSelection();
        if (this._cursor != null) {
            selection.setCursorLocation(this.mapPosition(this._cursor));
        }
        if (this._drop != null) {
            selection.setDropLocation(this.mapPosition(this._drop));
        }
        if (this._range != null) {
            DomPosition domPosition = this._range.getStart();
            DomPosition domPosition2 = this._range.getEnd();
            DomPosition domPosition3 = this.mapPosition(domPosition);
            DomPosition domPosition4 = this.mapPosition(domPosition2);
            if (domPosition != domPosition3 || domPosition2 != domPosition4) {
                selection.setRangeSelection(selection.createDomRange(domPosition3, domPosition4));
            }
        }
    }

    protected abstract DomPosition mapPosition(DomPosition var1);

    protected final AbstractModel getModel() {
        return this._model;
    }
}

