/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.util.DefaultPrefixLookup;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.helpers.NamespaceSupport;

public class NamespaceUtils {
    private static final String _XML_NS = "xmlns";
    private static final String _XML_NS_COLON = "xmlns:";
    private static final String _XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String _XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    public static Map getPrefixesInScope(Node node) {
        HashMap hashMap = new HashMap();
        NamespaceUtils._addPrefixesInScope(hashMap, node);
        return hashMap;
    }

    public static final void fixPrefixes(Node node, Node node2, DefaultPrefixLookup defaultPrefixLookup) {
        Document document;
        if (node2 == null) {
            throw new IllegalArgumentException("Node is null");
        }
        if (defaultPrefixLookup == null) {
            throw new IllegalArgumentException("Prefix lookup is null");
        }
        if (node2.getParentNode() == node) {
            throw new IllegalArgumentException("subTree shouldn't already be in doc");
        }
        if (node2.getNodeType() != 1 && node2.getNodeType() != 2) {
            return;
        }
        if (node2.getNodeType() == 2 && node.getNodeType() == 9) {
            throw new IllegalArgumentException("can't add an attribute to a document");
        }
        NamespaceSupportAdapter namespaceSupportAdapter = new NamespaceSupportAdapter(null);
        namespaceSupportAdapter.pushContext();
        String string = null;
        Node node3 = node;
        while (node3 != null) {
            NamedNodeMap namedNodeMap;
            if (node3.getNodeType() == 1 && (namedNodeMap = node3.getAttributes()) != null) {
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node4 = namedNodeMap.item(n);
                    String string2 = node4.getNodeName();
                    if (string2.startsWith(_XML_NS_COLON) && !namespaceSupportAdapter.containsURI(node4.getNodeValue()) && !namespaceSupportAdapter.containsPrefix(string2.substring(6))) {
                        String string3 = string2.substring(6);
                        namespaceSupportAdapter.declarePrefix(string3, node4.getNodeValue());
                    } else if (_XML_NS.equals(string2) && string == null) {
                        string = node4.getNodeValue();
                    }
                    ++n;
                }
            }
            node3 = node3.getParentNode();
        }
        if (string != null) {
            namespaceSupportAdapter.declarePrefix("", string);
        }
        if (node != null && (document = DomUtils.getOwnerDocument((Node)node)) != null) {
            Element element = document.getDocumentElement();
            if (element == null) {
                element = (Element)node2;
            }
            NamespaceUtils._fixPrefixesRecursively(namespaceSupportAdapter, node, node2, defaultPrefixLookup, element);
        }
    }

    private static final void _fixPrefixesRecursively(NamespaceSupportAdapter namespaceSupportAdapter, Node node, Node node2, DefaultPrefixLookup defaultPrefixLookup, Element element) {
        NamedNodeMap namedNodeMap;
        boolean bl;
        String string = node2.getNamespaceURI();
        String string2 = namespaceSupportAdapter.getURI("");
        namespaceSupportAdapter.pushContext();
        if (node2.getNodeType() == 2 && (_XMLNS_NAMESPACE.equals(string) || _XML_NAMESPACE.equals(string))) {
            return;
        }
        if (node2.getPrefix() == null && string != null && !"".equals(string)) {
            namespaceSupportAdapter.declarePrefix("", node2.getNamespaceURI());
        }
        boolean bl2 = bl = node2.getNodeType() == 1;
        if (string == null || string2 == null || !string.equals(string2)) {
            String string3 = namespaceSupportAdapter.getPrefix(string);
            String string4 = string != null ? defaultPrefixLookup.getDefaultPrefix(string) : null;
            String string5 = node2.getPrefix();
            String string6 = null;
            if (string6 == null) {
                String string7 = namespaceSupportAdapter.getURI(string3);
                String string8 = namespaceSupportAdapter.getURI(string5);
                String string9 = namespaceSupportAdapter.getURI(string4);
                if (string3 != null && (string7 == null || string7.equals(string))) {
                    string6 = string3;
                } else if (string5 != null && (string8 == null || string8.equals(string))) {
                    string6 = string5;
                } else if (string4 != null && (string9 == null || string9.equals(string))) {
                    string6 = string4;
                }
            }
            boolean bl3 = true;
            if (element == node2) {
                bl3 = false;
            }
            if (string6 != null && bl3) {
                node2.setPrefix(string6);
                if (bl) {
                    if (string6 == string5 && ((Element)node2).hasAttribute(_XML_NS + string5)) {
                        ((Element)node2).removeAttribute(_XML_NS_COLON + string5);
                    } else if (((Element)node2).hasAttribute(_XML_NS)) {
                        ((Element)node2).removeAttribute(_XML_NS);
                    }
                }
                if (!string6.equals(string3)) {
                    element.setAttributeNS(_XMLNS_NAMESPACE, _XML_NS_COLON + string6, string);
                    namespaceSupportAdapter.declarePrefix(string6, string);
                }
            } else if (bl) {
                String string10 = node2.getPrefix();
                if (string10 != null) {
                    if (((Element)node2).hasAttribute(_XML_NS_COLON + string10)) {
                        ((Element)node2).removeAttribute(_XML_NS_COLON + string10);
                    }
                    node2.setPrefix(null);
                }
                if (string != null || string == null && string2 != null) {
                    String string11 = string == null ? "" : string;
                    ((Element)node2).setAttributeNS(_XMLNS_NAMESPACE, _XML_NS, string11);
                    namespaceSupportAdapter.declarePrefix("", string11);
                }
            }
        } else if (node != null && string != null && string.equals(node.getNamespaceURI())) {
            NamedNodeMap namedNodeMap2;
            String string12;
            if (bl) {
                String string13 = node2.getPrefix();
                if (string13 != null) {
                    if (((Element)node2).hasAttribute(_XML_NS_COLON + string13)) {
                        ((Element)node2).removeAttribute(_XML_NS_COLON + string13);
                    }
                    node2.setPrefix(null);
                } else if (((Element)node2).hasAttribute(_XML_NS)) {
                    ((Element)node2).removeAttribute(_XML_NS);
                }
            }
            if ((string12 = node.getPrefix()) != null) {
                node2.setPrefix(string12);
            }
            if (bl && (namedNodeMap2 = node2.getAttributes()) != null) {
                int n = 0;
                while (n < namedNodeMap2.getLength()) {
                    Node node3 = namedNodeMap2.item(n);
                    String string14 = node3.getNodeValue();
                    if (string14.startsWith(_XML_NS_COLON) && string14.equals(node2.getNamespaceURI())) {
                        ((Element)node2).removeAttributeNode((Attr)node3);
                    }
                    ++n;
                }
            }
        } else {
            String string15 = node2.getPrefix();
            node2.setPrefix(null);
            if (bl) {
                NamedNodeMap namedNodeMap3;
                if (((Element)node2).hasAttribute(_XML_NS)) {
                    ((Element)node2).removeAttribute(_XML_NS);
                }
                if (string15 != null && (namedNodeMap3 = node2.getAttributes()) != null) {
                    int n = 0;
                    while (n < namedNodeMap3.getLength()) {
                        Node node4 = namedNodeMap3.item(n);
                        String string16 = node4.getNodeValue();
                        if (string16.startsWith(_XML_NS) && string16.equals(node2.getNamespaceURI())) {
                            ((Element)node2).removeAttributeNode((Attr)node4);
                        }
                        ++n;
                    }
                }
            }
        }
        if (node2.getNodeType() == 1 && (namedNodeMap = node2.getAttributes()) != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Node node5 = namedNodeMap.item(n);
                String string17 = node5.getNodeName();
                if (string17.startsWith(_XML_NS_COLON)) {
                    String string18 = string17.substring(6);
                    namespaceSupportAdapter.declarePrefix(string18, node5.getNodeValue());
                } else if (_XML_NS.equals(string17)) {
                    namespaceSupportAdapter.declarePrefix("", node5.getNodeValue());
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < namedNodeMap.getLength()) {
                int n3;
                Node node6 = namedNodeMap.item(n2);
                String string19 = node6.getNodeName();
                if (!(string19.startsWith(_XML_NS_COLON) || _XML_NAMESPACE.equals(node6.getNamespaceURI()) || _XMLNS_NAMESPACE.equals(node6.getNamespaceURI()) || (n3 = string19.indexOf(58)) == -1)) {
                    String string20 = node6.getNamespaceURI();
                    if (string20 != null) {
                        String string21 = string19.substring(0, n3);
                        if (namespaceSupportAdapter.containsURI(string20)) {
                            node6.setPrefix(namespaceSupportAdapter.getPrefix(string20));
                        } else {
                            Element element2 = ((Attr)node6).getOwnerElement();
                            element2.setAttributeNS(_XMLNS_NAMESPACE, _XML_NS_COLON + string21, string20);
                            namespaceSupportAdapter.declarePrefix(string21, string20);
                        }
                    } else {
                        node6.setPrefix(null);
                    }
                }
                ++n2;
            }
        }
        Node node7 = node2.getFirstChild();
        while (node7 != null) {
            NamespaceUtils._fixPrefixesRecursively(namespaceSupportAdapter, node2, node7, defaultPrefixLookup, element);
            node7 = node7.getNextSibling();
        }
        namespaceSupportAdapter.popContext();
    }

    private static void _addPrefixesInScope(Map map, Node node) {
        NamedNodeMap namedNodeMap;
        if (node == null) {
            return;
        }
        NamespaceUtils._addPrefixesInScope(map, node.getParentNode());
        if (DomUtils.isElement((Node)node) && (namedNodeMap = node.getAttributes()) != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string = attr.getNodeName();
                if (string != null) {
                    if (_XML_NS.equals(string)) {
                        map.put("", attr.getValue());
                    } else if (string.startsWith(_XML_NS_COLON)) {
                        String string2 = DomUtils.getLocalName((Node)attr);
                        map.put(string2, attr.getValue());
                    }
                }
                ++n;
            }
        }
    }

    private static class NamespaceSupportAdapter
    extends NamespaceSupport {
        public String getPrefix(String string) {
            if (string == null) {
                return null;
            }
            return super.getPrefix(string);
        }

        public String getURI(String string) {
            if (string == null) {
                return null;
            }
            return super.getURI(string);
        }

        public boolean containsPrefix(String string) {
            return this.getURI(string) != null;
        }

        public boolean containsURI(String string) {
            return this.getPrefix(string) != null;
        }

        private NamespaceSupportAdapter() {
        }

        NamespaceSupportAdapter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

