/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.awt.event.ActionEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import org.w3c.dom.Node;

public class XmlCreationAction
extends AbstractAction {
    private static final String _CREATE_COMMAND = "create";
    private boolean _iconInitialized;
    private List _xmlKeys;
    private DomPosition _position;
    private AbstractModel _model;
    private static final Logger _LOGGER = Logger.getLogger(XmlCreationAction.class.getName());

    public XmlCreationAction(AbstractModel abstractModel, DomPosition domPosition, XmlKey xmlKey) {
        this.$init$();
        this._init(abstractModel, domPosition, Collections.singletonList(xmlKey));
    }

    public XmlCreationAction(AbstractModel abstractModel, DomPosition domPosition, List list) {
        this.$init$();
        this._init(abstractModel, domPosition, Collections.unmodifiableList(list));
    }

    public static List createActions(AbstractModel abstractModel, List list, DomPosition domPosition) {
        ArrayList<XmlCreationAction> arrayList = new ArrayList<XmlCreationAction>(list.size());
        for (List list2 : list) {
            arrayList.add(new XmlCreationAction(abstractModel, domPosition, list2));
        }
        return arrayList;
    }

    public static Collection createLazyActionCollectionFromKeyCollection(AbstractModel abstractModel, DomPosition domPosition, Collection collection) {
        return new 2(collection, abstractModel, domPosition, collection);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getLastXmlKey() != null) {
            List list = this.getXmlKeys();
            int n = list.size();
            String string = this._model.getTranslatedString("INSERT_DESCRIPTION_FORMAT");
            String string2 = FastMessageFormat.formatMessage(string, this.getValue("Name").toString());
            new 1(this, string2, list, n).run(this._model);
        } else {
            _LOGGER.log(Level.WARNING, "Can't create element because no XmlKey for {0}", this);
        }
    }

    public List getXmlKeys() {
        return this._xmlKeys;
    }

    public XmlKey getLastXmlKey() {
        List list = this.getXmlKeys();
        int n = list.size();
        if (n == 0) {
            return null;
        }
        return (XmlKey)list.get(n - 1);
    }

    public Object getValue(String string) {
        Object object = super.getValue(string);
        if ("SmallIcon".equals(string) && !this._iconInitialized) {
            object = this._createIcon();
            this._iconInitialized = true;
        }
        return object;
    }

    public String toString() {
        return (String)this.getValue("Name");
    }

    private Icon _createIcon() {
        XmlKey xmlKey = this.getLastXmlKey();
        if (xmlKey != null) {
            Icon icon = this._model.getXmlMetadataResolver().getSmallIcon(xmlKey);
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            }
            return icon;
        }
        return null;
    }

    private void _init(AbstractModel abstractModel, DomPosition domPosition, List list) {
        this.putValue("ActionCommandKey", _CREATE_COMMAND);
        this._model = abstractModel;
        this._position = domPosition;
        this._xmlKeys = list;
        XmlKey xmlKey = this.getLastXmlKey();
        this.setEnabled(xmlKey != null);
        String string = abstractModel.getXmlMetadataResolver().getShortDisplayName(xmlKey);
        this.putValue("Name", string);
        char c = Character.toUpperCase(string.charAt(0));
        this.putValue("MnemonicKey", new Integer(c));
    }

    void $init$() {
        this._iconInitialized = false;
    }

    static DomPosition ra$_position(XmlCreationAction xmlCreationAction) {
        return xmlCreationAction._position;
    }

    static AbstractModel ra$_model(XmlCreationAction xmlCreationAction) {
        return xmlCreationAction._model;
    }

    public static final class 2
    extends AbstractCollection {
        private final /* synthetic */ Collection v$keyCollection;
        private final /* synthetic */ AbstractModel v$model;
        private final /* synthetic */ DomPosition v$position;
        private final /* synthetic */ Collection v$$keyCollection;

        public int size() {
            return this.v$keyCollection.size();
        }

        public Iterator iterator() {
            return new Itor();
        }

        public 2(Collection collection, AbstractModel abstractModel, DomPosition domPosition, Collection collection2) {
            this.v$$keyCollection = collection2;
            this.v$position = domPosition;
            this.v$model = abstractModel;
            this.v$keyCollection = collection;
        }

        static Collection ra$v$$keyCollection(2 var0) {
            return var0.v$$keyCollection;
        }

        static AbstractModel ra$v$model(2 var0) {
            return var0.v$model;
        }

        static DomPosition ra$v$position(2 var0) {
            return var0.v$position;
        }

        public class Itor
        implements Iterator {
            private final Iterator _realItor;

            public boolean hasNext() {
                return this._realItor.hasNext();
            }

            public Object next() {
                XmlKey xmlKey = (XmlKey)this._realItor.next();
                return new XmlCreationAction(2.ra$v$model(2.this), 2.ra$v$position(2.this), xmlKey);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            void $init$() {
                this._realItor = 2.ra$v$$keyCollection(2.this).iterator();
            }

            Itor() {
                this.$init$();
            }
        }
    }

    public final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ List v$xmlKeys;
        private final /* synthetic */ int v$keyCount;
        final /* synthetic */ XmlCreationAction this$0;

        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            DomPosition domPosition = XmlCreationAction.ra$_position(this.this$0);
            int n = 0;
            while (true) {
                XmlKey xmlKey = (XmlKey)this.v$xmlKeys.get(n);
                Node node = XmlCreationAction.ra$_model(this.this$0).insertXmlKey(xmlKey, domPosition);
                if (++n >= this.v$keyCount) break;
                if (node == null) continue;
                domPosition = DomPositionFactory.createInsideOrAfterPosition((Node)node);
            }
        }

        public 1(XmlCreationAction xmlCreationAction, String string, List list, int n) {
            this.v$keyCount = n;
            this.v$xmlKeys = list;
            this.this$0 = xmlCreationAction;
            super(string);
        }
    }
}

