/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.KeyStroke;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.bali.xml.util.XmlSingleSelectionAction;
import org.w3c.dom.Node;

public class XmlCustomizeAction
extends XmlSingleSelectionAction {
    private static final String _PROPERTIES_KEY = "Properties";

    public XmlCustomizeAction() {
        super(null, KeyStroke.getKeyStroke(10, 0), "customizeNode");
        this.putValue("XmlContext.MUTATES_MODEL", Boolean.TRUE);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NodeCustomizer nodeCustomizer;
        XmlKey xmlKey;
        Node node;
        if (!this.isEnabled()) {
            return;
        }
        this.setEnabled(false);
        AbstractModel abstractModel = this.getModel();
        XmlModel xmlModel = abstractModel.getBaseModel();
        XmlMetadataResolver xmlMetadataResolver = xmlModel.getXmlMetadataResolver();
        XmlContext xmlContext = xmlModel.getContext();
        boolean bl = false;
        abstractModel.acquireReadLock();
        try {
            node = XmlCustomizeAction._getBaseModelNode(abstractModel, this._getTargetNode(actionEvent));
            if (node != null) {
                xmlKey = xmlMetadataResolver.getNodeXmlKey(node);
                nodeCustomizer = XmlModelUtils.getCustomizerOrDefault(xmlModel, xmlKey, node);
                bl = nodeCustomizer != null && nodeCustomizer.isNodeCustomizable(xmlContext, node, xmlKey) && !xmlMetadataResolver.isImmutable(node);
            } else {
                nodeCustomizer = null;
                xmlKey = null;
            }
        }
        finally {
            abstractModel.releaseReadLock();
        }
        if (bl) {
            new 1(this, String.valueOf(this.getValue("Name")), nodeCustomizer, xmlContext, node, xmlKey).run(abstractModel);
            this.setEnabled(true);
        }
    }

    private Node _getTargetNode(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Node) {
            return (Node)actionEvent.getSource();
        }
        AbstractModel abstractModel = this.getModel();
        return abstractModel.getSelection().getFirstSelectedNode();
    }

    public static final boolean isNodeCustomizable(AbstractModel abstractModel, Node node) {
        boolean bl = false;
        XmlModel xmlModel = abstractModel.getBaseModel();
        Node node2 = XmlCustomizeAction._getBaseModelNode(abstractModel, node);
        if (node2 != null) {
            NodeCustomizer nodeCustomizer;
            XmlKey xmlKey = xmlModel.getNodeXmlKey(node2);
            XmlMetadataResolver xmlMetadataResolver = xmlModel.getXmlMetadataResolver();
            if (xmlKey != null && (nodeCustomizer = XmlModelUtils.getCustomizerOrDefault(xmlModel, xmlKey, node2)) != null) {
                bl = nodeCustomizer.isNodeCustomizable(abstractModel.getContext(), node, xmlKey) && !xmlMetadataResolver.isImmutable(node);
            }
        }
        return bl;
    }

    private static Node _getBaseModelNode(AbstractModel abstractModel, Node node) {
        if (abstractModel instanceof XmlView) {
            return ((XmlView)abstractModel).viewToModel(node);
        }
        return node;
    }

    protected boolean isEnabledImpl(Node node) {
        return XmlCustomizeAction.isNodeCustomizable(this.getModel(), node);
    }

    protected void updateName(Node node, boolean bl) {
        if (this.getModel() == null) {
            this.putValue("Name", null);
        } else {
            Object[] objectArray;
            if (bl && node != null) {
                XmlMetadataResolver xmlMetadataResolver = this.getModel().getXmlMetadataResolver();
                objectArray = new String[]{xmlMetadataResolver.getMediumDisplayName(node)};
            } else {
                objectArray = new String[]{""};
            }
            String string = this.getModel().getTranslatedString(_PROPERTIES_KEY);
            this.putValue("Name", MessageFormat.format(string, objectArray));
        }
    }

    public final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ NodeCustomizer v$customizer;
        private final /* synthetic */ XmlContext v$context;
        private final /* synthetic */ Node v$n;
        private final /* synthetic */ XmlKey v$key;
        final /* synthetic */ XmlCustomizeAction this$0;

        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            boolean bl = this.v$customizer.customizeNode(this.v$context, this.v$n, this.v$key);
            if (!bl) {
                this.cancelTask();
            }
        }

        public 1(XmlCustomizeAction xmlCustomizeAction, String string, NodeCustomizer nodeCustomizer, XmlContext xmlContext, Node node, XmlKey xmlKey) {
            this.v$key = xmlKey;
            this.v$n = node;
            this.v$context = xmlContext;
            this.v$customizer = nodeCustomizer;
            this.this$0 = xmlCustomizeAction;
            super(string);
        }
    }
}

