/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.text.Collator;
import java.util.Comparator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;

public class XmlKeyDisplayNameComparator
implements Comparator {
    private Collator _collator;
    private XmlMetadataResolver _resolver;

    public XmlKeyDisplayNameComparator(XmlMetadataResolver xmlMetadataResolver) {
        this(xmlMetadataResolver, null);
    }

    public XmlKeyDisplayNameComparator(XmlMetadataResolver xmlMetadataResolver, Collator collator) {
        if (xmlMetadataResolver == null) {
            throw new IllegalArgumentException("resolver must not be null");
        }
        this._resolver = xmlMetadataResolver;
        if (collator == null) {
            collator = Collator.getInstance(xmlMetadataResolver.getContext().getLocale());
        }
        this._collator = collator;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof XmlKey && object2 instanceof XmlKey) {
            XmlKey xmlKey = (XmlKey)object;
            XmlKey xmlKey2 = (XmlKey)object2;
            int n = this._resolver.getDisplayOrder(xmlKey);
            int n2 = this._resolver.getDisplayOrder(xmlKey2);
            if (n == -1 && n2 == -1) {
                return this._collator.compare(this._resolver.getShortDisplayName(xmlKey), this._resolver.getShortDisplayName(xmlKey2));
            }
            if (n == -1) {
                return 1;
            }
            if (n2 == -1) {
                return -1;
            }
            return n - n2;
        }
        if (object instanceof XmlKey) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return object instanceof XmlKeyDisplayNameComparator;
    }
}

