/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.task.NoNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.bali.xml.validator.DefaultValidationContext;
import oracle.bali.xml.validator.ValidationContext;
import oracle.bali.xml.validator.ValidationErrorLog;
import oracle.bali.xml.validator.ValidationException;
import oracle.bali.xml.validator.Validator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;

public final class XmlModelUtils {
    public static String getDisplayName(AbstractModel abstractModel, Node node) {
        if (node == null) {
            return null;
        }
        if (abstractModel.isInModelDocumentHierarchy(node)) {
            String string = abstractModel.getTranslatedString("NODE_NOT_IN_DOCUMENT_FORMAT");
            return FastMessageFormat.formatMessage(string, node.getNodeName());
        }
        return abstractModel.getXmlMetadataResolver().getMediumDisplayName(node);
    }

    public static Node findFirstNodeByKey(AbstractModel abstractModel, XmlKey xmlKey) {
        if (abstractModel == null) {
            throw new IllegalArgumentException("null model");
        }
        if (xmlKey == null) {
            throw new IllegalArgumentException("null key");
        }
        Document document = abstractModel.getDocument();
        TreeTraversal treeTraversal = abstractModel.getTreeTraversal();
        Node node = document;
        while (node != null) {
            XmlKey xmlKey2 = abstractModel.getNodeXmlKey(node);
            if (xmlKey.equals((Object)xmlKey2)) {
                return node;
            }
            node = treeTraversal.getNextNode(node);
        }
        return null;
    }

    public static void deleteNodesOrRange(AbstractModel abstractModel, String string, Collection collection, DomRange domRange, boolean bl) throws XmlCommitException {
        if (domRange != null) {
            abstractModel.deleteNodes(string, domRange, bl);
        } else if (collection != null) {
            abstractModel.deleteNodes(string, collection, bl);
        }
    }

    public static Collection deleteSelection(AbstractModel abstractModel, String string, boolean bl) throws XmlCommitException {
        Collection[] collectionArray = new Collection[1];
        new 1(collectionArray, string, bl).runThrowingXCE(abstractModel);
        return collectionArray[0];
    }

    public static Node createNodeFromKey(AbstractModel abstractModel, XmlKey xmlKey, DomPosition domPosition) {
        Node node = DomUtils.createNodeFromKey((Document)abstractModel.getDocument(), (XmlKey)xmlKey);
        return XmlModelUtils.initializeAndInvokeCreatorIfNeededOrSpecified(abstractModel, xmlKey, domPosition, node);
    }

    public static Node initializeAndInvokeCreatorIfNeededOrSpecified(AbstractModel abstractModel, XmlKey xmlKey, DomPosition domPosition, Node node) {
        XmlMetadataResolver xmlMetadataResolver = abstractModel.getXmlMetadataResolver();
        XmlContext xmlContext = abstractModel.getContext();
        boolean bl = DomUtils.isElement((Node)node) ? abstractModel.getBaseModel().initializeNewNode(node, xmlKey) ^ true : true;
        NodeCreator nodeCreator = xmlMetadataResolver.getCreationWizard(xmlKey);
        if (nodeCreator == null && bl) {
            nodeCreator = abstractModel.getContext().getDefaultNodeCreator(xmlKey);
        }
        if (nodeCreator != null) {
            node = nodeCreator.createNode(xmlContext, xmlKey, domPosition, node);
        }
        return node;
    }

    public static Collection getCloneOfSelection(AbstractModel abstractModel) {
        abstractModel.acquireReadLock();
        try {
            Selection selection = abstractModel.getSelection();
            if (selection.isEmpty()) {
                List list = Collections.EMPTY_LIST;
                abstractModel.releaseReadLock();
                return list;
            }
            if (selection.hasRangeSelection()) {
                List list = DomUtils.cloneRangeToList((TreeTraversal)abstractModel.getTreeTraversal(), (DomRange)selection.getRangeSelection());
                abstractModel.releaseReadLock();
                return list;
            }
            Collection collection = DomUtils.rationalizeCollectionOfNodes((TreeTraversal)abstractModel.getTreeTraversal(), (Collection)selection.getSelectedNodesList());
            Collection collection2 = XmlModelUtils._cloneNodes(collection);
            abstractModel.releaseReadLock();
            return collection2;
        }
        catch (Throwable throwable) {
            abstractModel.releaseReadLock();
            throw throwable;
        }
    }

    public static NodeCustomizer getCustomizerOrDefault(AbstractModel abstractModel, XmlKey xmlKey, Node node) {
        XmlMetadataResolver xmlMetadataResolver = abstractModel.getXmlMetadataResolver();
        NodeCustomizer nodeCustomizer = null;
        nodeCustomizer = node != null ? xmlMetadataResolver.getCustomizer(node) : xmlMetadataResolver.getCustomizer(xmlKey);
        if (nodeCustomizer == null) {
            nodeCustomizer = abstractModel.getContext().getDefaultNodeCustomizer(xmlKey);
        }
        return nodeCustomizer;
    }

    public static Node convert(XmlModel xmlModel, Node node, XmlKey xmlKey, Set set) {
        short s = node.getNodeType();
        short s2 = xmlKey.getNodeType();
        if (s == 3 && s2 == 4) {
            CDATASection cDATASection = xmlModel.getDocument().createCDATASection(node.getNodeValue());
            node.getParentNode().replaceChild(cDATASection, node);
            return cDATASection;
        }
        if (s == 4 && s2 == 3) {
            Text text = xmlModel.getDocument().createTextNode(node.getNodeValue());
            node.getParentNode().replaceChild(text, node);
            return text;
        }
        if (1 == s && 1 == s2) {
            return XmlModelUtils._convertElement(xmlModel, node, xmlKey, set);
        }
        return null;
    }

    public static Node surroundSelection(XmlModel xmlModel, XmlKey xmlKey) throws XmlCommitException {
        Collection collection;
        List list;
        DomRange domRange;
        Collection collection2;
        if (xmlModel == null || xmlKey == null || xmlKey.getNodeType() != 1) {
            throw new IllegalArgumentException("Invalid arguments passed to surround");
        }
        Selection selection = xmlModel.getSelection();
        if (selection.hasRangeSelection()) {
            collection2 = DomUtils.cloneRangeToList((TreeTraversal)xmlModel.getTreeTraversal(), (DomRange)selection.getRangeSelection());
            DomPosition domPosition = selection.getRangeSelection().getStart();
            selection.setCursorLocation(domPosition);
            xmlModel.splitAtPositionIfNeeded(domPosition, true);
            domRange = selection.getRangeSelection();
            list = null;
        } else {
            List list2 = XmlModelUtils._getSelectedNodesInOrderUnderOneParent(selection);
            if (list2.isEmpty()) {
                return null;
            }
            list = list2;
            selection.setCursorLocation(DomPositionFactory.before((Node)((Node)list2.get(0))));
            collection2 = XmlModelUtils._cloneNodes(list);
            domRange = null;
        }
        XmlModelUtils.deleteNodesOrRange(xmlModel, "delete old nodes in surround", list, domRange, false);
        Node node = xmlModel.insertXmlKey(xmlKey, selection.getCursorLocation());
        if (node != null && (collection = xmlModel.insertNodes(DomPositionFactory.inside((Node)node), "inserting old nodes' clones in surround", collection2, false)) != null) {
            return node;
        }
        return null;
    }

    public static boolean fixedAttributeMightHaveChanged(XmlModelEvent xmlModelEvent) {
        if (xmlModelEvent.matchesFlags(8)) {
            NodeChangeDetails nodeChangeDetails = xmlModelEvent.getNodeChangeDetails();
            if (nodeChangeDetails != null && nodeChangeDetails != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
                Set set = nodeChangeDetails.getChangedNodes();
                if (!set.isEmpty()) {
                    for (Node node : set) {
                        QualifiedName qualifiedName;
                        Map map;
                        XmlKey xmlKey;
                        QualifiedName qualifiedName2;
                        String string;
                        if (!DomUtils.isElement((Node)node) || (string = (qualifiedName2 = (xmlKey = xmlModelEvent.getModel().getNodeXmlKey(node)).getElementQName()).getAttributeName()) == null || !(map = nodeChangeDetails.getPriorAttributeValues(node)).containsKey(qualifiedName = QualifiedName.getQualifiedName((String)qualifiedName2.getAttributeNamespace(), (String)string))) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static List _getSelectedNodesInOrderUnderOneParent(Selection selection) {
        int n = selection.getSelectedNodesCount();
        if (n == 1) {
            return selection.getSelectedNodesList();
        }
        if (n > 1) {
            Node node = selection.getFirstSelectedNode().getParentNode();
            ArrayList<Node> arrayList = new ArrayList<Node>(selection.getSelectedNodesCount());
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (selection.contains(node2)) {
                    arrayList.add(node2);
                }
                node2 = node2.getNextSibling();
            }
            if (arrayList.size() == n) {
                return arrayList;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static Node _convertElement(XmlModel xmlModel, Node node, XmlKey xmlKey, Set set) {
        boolean bl;
        if (XmlModelUtils._wouldViolateMaxoccurs(node, xmlKey)) {
            return null;
        }
        Element element = (Element)DomUtils.createNodeFromKey((Document)xmlModel.getDocument(), (XmlKey)xmlKey);
        XmlModelUtils._copyAttributes(xmlKey, (Element)node, element);
        XmlModelUtils._copyChildren(node, element);
        Node node2 = node.getParentNode();
        xmlModel.fixPrefixes(node2, element);
        node2.replaceChild(element, node);
        boolean bl2 = xmlModel.initializeNewNode(element, xmlKey) ^ true;
        NodeCustomizer nodeCustomizer = null;
        nodeCustomizer = bl2 ? XmlModelUtils.getCustomizerOrDefault(xmlModel, xmlKey, element) : xmlModel.getXmlMetadataResolver().getCustomizer(element);
        if (nodeCustomizer != null && !(bl = nodeCustomizer.customizeNode(xmlModel.getContext(), element, xmlKey))) {
            return null;
        }
        if (element == null) {
            return null;
        }
        XmlModelUtils._handleInvalidNodes(xmlModel, element, set);
        set.remove(element);
        return element;
    }

    private static boolean _wouldViolateMaxoccurs(Node node, XmlKey xmlKey) {
        Node node2 = node.getParentNode();
        QualifiedName qualifiedName = xmlKey.getElementQName();
        if ("http://xmlns.oracle.com/uix/ui".equals(qualifiedName.getNamespace()) && "contents".equals(qualifiedName.getName())) {
            Node node3 = DomUtils.getNamedChild((Node)node2, (String)qualifiedName.getNamespace(), (String)qualifiedName.getName());
            return node3 != null;
        }
        return false;
    }

    private static void _copyAttributes(XmlKey xmlKey, Element element, Element element2) {
        QualifiedName qualifiedName = xmlKey.getElementQName();
        String string = qualifiedName.getAttributeName();
        String string2 = qualifiedName.getAttributeNamespace();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            if (!XmlModelUtils._hasName(attr, string2, string)) {
                Attr attr2 = (Attr)attr.cloneNode(true);
                element2.setAttributeNodeNS(attr2);
            }
            ++n;
        }
    }

    private static boolean _hasName(Node node, String string, String string2) {
        String string3 = DomUtils.getLocalName((Node)node);
        if (string3.equals(string2)) {
            String string4 = node.getNamespaceURI();
            if (string == null) {
                return string4 == null;
            }
            return string.equals(string4);
        }
        return false;
    }

    private static void _copyChildren(Node node, Node node2) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node3 = nodeList.item(n);
            node2.appendChild(node3.cloneNode(true));
            ++n;
        }
    }

    private static void _handleInvalidNodes(XmlModel xmlModel, Node node, Set set) {
        ValidationErrorLog validationErrorLog = new ValidationErrorLog();
        DefaultValidationContext defaultValidationContext = new DefaultValidationContext(xmlModel.getContext().getGrammarResolver(), (ErrorHandler)validationErrorLog, null);
        boolean bl = Validator.validateSubtree((ValidationContext)defaultValidationContext, (Node)node);
        if (!bl) {
            for (Object e : validationErrorLog.getErrors()) {
                if (!(e instanceof ValidationException)) continue;
                ValidationException validationException = (ValidationException)((Object)e);
                set.add(validationException.getInvalidNode());
            }
        }
    }

    private static Collection _cloneNodes(Collection collection) {
        ArrayList<Node> arrayList = new ArrayList<Node>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Node)iterator.next()).cloneNode(true));
        }
        return arrayList;
    }

    private XmlModelUtils() {
    }

    public static final class 1
    extends NoNameTransactionTask {
        private final /* synthetic */ Collection[] v$ret;
        private final /* synthetic */ String v$txnName;
        private final /* synthetic */ boolean v$updateSelection;

        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            Selection selection = abstractModel.getSelection();
            this.v$ret[0] = selection.hasRangeSelection() ? abstractModel.deleteNodes(this.v$txnName, selection.getRangeSelection(), this.v$updateSelection) : abstractModel.deleteNodes(this.v$txnName, selection.getSelectedNodesList(), this.v$updateSelection);
        }

        public 1(Collection[] collectionArray, String string, boolean bl) {
            this.v$updateSelection = bl;
            this.v$txnName = string;
            this.v$ret = collectionArray;
        }
    }
}

