/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.KeyStroke;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.share.BaseAction;
import org.w3c.dom.Node;

public class XmlNavigationActions
implements ActionListener {
    private final XmlView _view;
    private final TreeTraversal _traversal;
    private final Action _nextAction;
    private final Action _previousAction;
    private final Action _nextInsertionPositionAction;
    private final Action _previousInsertionPositionAction;

    public XmlNavigationActions(XmlView xmlView, TreeTraversal treeTraversal) {
        if (xmlView == null) {
            throw new IllegalArgumentException("view must be non-null");
        }
        this._view = xmlView;
        this._traversal = treeTraversal;
        this._nextAction = new BaseAction(xmlView.getTranslatedString("NEXT_DESCRIPTION"), 78, KeyStroke.getKeyStroke(9, 0), "nextNode", this);
        this._previousAction = new BaseAction(xmlView.getTranslatedString("PREVIOUS_DESCRIPTION"), 80, KeyStroke.getKeyStroke(9, 1), "prevNode", this);
        this._nextInsertionPositionAction = new BaseAction(xmlView.getTranslatedString("CURSOR_FORWARD_DESCRIPTION"), 0, KeyStroke.getKeyStroke(39, 2), "nextInsertionPos", this);
        this._previousInsertionPositionAction = new BaseAction(xmlView.getTranslatedString("CURSOR_BACKWARD_DESCRIPTION"), 0, KeyStroke.getKeyStroke(37, 2), "prevInsertionPos", this);
    }

    public Action getNextInsertionPositionAction() {
        return this._nextInsertionPositionAction;
    }

    public Action getPreviousInsertionPositionAction() {
        return this._previousInsertionPositionAction;
    }

    public Action getNextAction() {
        return this._nextAction;
    }

    public Action getPreviousAction() {
        return this._previousAction;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Selection selection = this._view.getSelection();
        boolean bl = "prevNode".equals(string);
        boolean bl2 = "nextNode".equals(string);
        boolean bl3 = "prevInsertionPos".equals(string);
        boolean bl4 = "nextInsertionPos".equals(string);
        new 1(this, bl, bl2, selection, bl3, bl4).run(this._view);
    }

    private void _handleInsertionPosPrevNextInsideTask(boolean bl, Selection selection) {
        DomPosition domPosition;
        DomPosition domPosition2 = selection.getCursorLocation();
        if (domPosition2 == null) {
            if (!selection.isEmpty()) {
                domPosition2 = bl ? DomPositionFactory.createInsideOrBeforePosition((Node)selection.getEarliestSelectedNode()) : DomPositionFactory.createInsideOrAfterPosition((Node)selection.getLatestSelectedNode());
            } else {
                return;
            }
        }
        do {
            domPosition2 = domPosition = this._findNextInsertionPos(bl, selection, domPosition2);
        } while (domPosition != null && !domPosition.equals((Object)this._view.convertInsertionPosition(domPosition)));
        if (domPosition != null) {
            selection.setCursorLocation(domPosition);
        }
    }

    private DomPosition _findNextInsertionPos(boolean bl, Selection selection, DomPosition domPosition) {
        XmlMetadataResolver xmlMetadataResolver = this._view.getXmlMetadataResolver();
        Node node = domPosition.getTargetNode();
        DomPosition domPosition2 = null;
        if (bl) {
            if (domPosition.isInside()) {
                domPosition2 = domPosition.getBeforePosition();
            } else if (domPosition.isAfter()) {
                Node node2 = this._traversal.getLastChild(node);
                domPosition2 = node2 != null ? DomPositionFactory.createDomPosition((Node)node2, (int)2) : (xmlMetadataResolver.canAddChild(node) ? domPosition.getInsidePosition() : domPosition.getBeforePosition());
            } else {
                Node node3 = this._traversal.getPreviousSibling(node);
                if (node3 != null) {
                    domPosition2 = DomPositionFactory.createDomPosition((Node)node3, (int)2);
                } else {
                    Node node4 = this._traversal.getParentNode(node);
                    if (node4 != null) {
                        domPosition2 = DomPositionFactory.createDomPosition((Node)node4, (int)1);
                    }
                }
            }
        } else if (domPosition.isInside()) {
            domPosition2 = domPosition.getAfterPosition();
        } else if (domPosition.isBefore()) {
            Node node5 = this._traversal.getFirstChild(node);
            domPosition2 = node5 != null ? DomPositionFactory.createDomPosition((Node)node5, (int)1) : (xmlMetadataResolver.canAddChild(node) ? domPosition.getInsidePosition() : domPosition.getAfterPosition());
        } else {
            Node node6 = this._traversal.getNextSibling(node);
            if (node6 != null) {
                domPosition2 = DomPositionFactory.createDomPosition((Node)node6, (int)1);
            } else {
                Node node7 = this._traversal.getParentNode(node);
                if (node7 != null) {
                    domPosition2 = DomPositionFactory.createDomPosition((Node)node7, (int)2);
                }
            }
        }
        return domPosition2;
    }

    private void _selectCursorNodeInsideTask(Selection selection) {
        DomPosition domPosition = selection.getCursorLocation();
        if (domPosition != null) {
            selection.set(domPosition.getTargetNode());
        }
    }

    private void _doPrevOrNextNodeInsideTask(boolean bl, Selection selection) {
        Node node;
        if (bl) {
            node = selection.getEarliestSelectedNode();
            if ((node = this._traversal.getPreviousNode(node)) == null || node.getNodeType() == 9) {
                node = DomUtils.getLastDescendant((TreeTraversal)this._traversal, (Node)this._view.getDocument());
            }
        } else {
            node = selection.getLatestSelectedNode();
            if ((node = this._traversal.getNextNode(node)) == null) {
                node = this._view.getDocument();
                node = this._traversal.getNextNode(node);
            }
        }
        if (node == null) {
            return;
        }
        int n = this._view.getXmlMetadataResolver().canAddChild(node) ? 0 : (bl ? 1 : 2);
        DomPosition domPosition = DomPositionFactory.createDomPosition((Node)node, (int)n);
        selection.setCursorLocation(domPosition);
        selection.set(node);
    }

    static void mav$_selectCursorNodeInsideTask(XmlNavigationActions xmlNavigationActions, Selection selection) {
        xmlNavigationActions._selectCursorNodeInsideTask(selection);
    }

    static void mav$_doPrevOrNextNodeInsideTask(XmlNavigationActions xmlNavigationActions, boolean bl, Selection selection) {
        xmlNavigationActions._doPrevOrNextNodeInsideTask(bl, selection);
    }

    static void mav$_handleInsertionPosPrevNextInsideTask(XmlNavigationActions xmlNavigationActions, boolean bl, Selection selection) {
        xmlNavigationActions._handleInsertionPosPrevNextInsideTask(bl, selection);
    }

    public final class 1
    extends NonDomMutationTransactionTask {
        private final /* synthetic */ boolean v$isPreviousCmd;
        private final /* synthetic */ boolean v$isNextCmd;
        private final /* synthetic */ Selection v$selection;
        private final /* synthetic */ boolean v$isPosPreviousCmd;
        private final /* synthetic */ boolean v$isPosNextCmd;
        final /* synthetic */ XmlNavigationActions this$0;

        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            if (this.v$isPreviousCmd || this.v$isNextCmd) {
                if (this.v$selection.isEmpty()) {
                    XmlNavigationActions.mav$_selectCursorNodeInsideTask(this.this$0, this.v$selection);
                } else {
                    XmlNavigationActions.mav$_doPrevOrNextNodeInsideTask(this.this$0, this.v$isPreviousCmd, this.v$selection);
                }
            } else if (this.v$isPosPreviousCmd || this.v$isPosNextCmd) {
                XmlNavigationActions.mav$_handleInsertionPosPrevNextInsideTask(this.this$0, this.v$isPosPreviousCmd, this.v$selection);
            }
        }

        public 1(XmlNavigationActions xmlNavigationActions, boolean bl, boolean bl2, Selection selection, boolean bl3, boolean bl4) {
            this.v$isPosNextCmd = bl4;
            this.v$isPosPreviousCmd = bl3;
            this.v$selection = selection;
            this.v$isNextCmd = bl2;
            this.v$isPreviousCmd = bl;
            this.this$0 = xmlNavigationActions;
        }
    }
}

